<h2>Why is this an issue?</h2>
<p>Java 7’s try-with-resources structure automatically handles closing the resources that the <code>try</code> itself opens. Thus, adding an explicit
<code>close()</code> call is redundant and potentially confusing.</p>
<h3>Noncompliant code example</h3>

```java
try (PrintWriter writer = new PrintWriter(process.getOutputStream())) {
  String contents = file.contents();
  writer.write(new Gson().toJson(new MyObject(contents)));
  writer.flush();
  writer.close();  // Noncompliant
}
```
<h3>Compliant solution</h3>

```java
try (PrintWriter writer = new PrintWriter(process.getOutputStream())) {
  String contents = file.contents();
  writer.write(new Gson().toJson(new MyObject(contents)));
  writer.flush();
}
```