<h2>Why is this an issue?</h2>
<p>The underlying implementation of <code>String::replaceAll</code> calls the <code>java.util.regex.Pattern.compile()</code> method each time it is
called even if the first argument is not a regular expression. This has a significant performance cost and therefore should be used with care.</p>
<p>When <code>String::replaceAll</code> is used, the first argument should be a real regular expression. If it’s not the case,
<code>String::replace</code> does exactly the same thing as <code>String::replaceAll</code> without the performance drawback of the regex.</p>
<p>This rule raises an issue for each <code>String::replaceAll</code> used with a <code>String</code> as first parameter which doesn’t contains
special regex character or pattern.</p>
<h3>Noncompliant code example</h3>

```java
String init = "Bob is a Bird... Bob is a Plane... Bob is Superman!";
String changed = init.replaceAll("Bob is", "It's"); // Noncompliant
changed = changed.replaceAll("\\.\\.\\.", ";"); // Noncompliant
```
<h3>Compliant solution</h3>

```java
String init = "Bob is a Bird... Bob is a Plane... Bob is Superman!";
String changed = init.replace("Bob is", "It's");
changed = changed.replace("...", ";");
```
<p>Or, with a regex:</p>

```java
String init = "Bob is a Bird... Bob is a Plane... Bob is Superman!";
String changed = init.replaceAll("\\w*\\sis", "It's");
changed = changed.replaceAll("\\.{3}", ";");
```
<h2>Resources</h2>
<ul>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S4248'>java:S4248</a> - Regex patterns should not be created needlessly </li>
</ul>