<h2>Why is this an issue?</h2>
<p>It can be extremely confusing when a <code>for</code> loop’s counter is incremented outside of its increment clause. In such cases, the increment
should be moved to the loop’s increment clause if at all possible.</p>
<h3>Noncompliant code example</h3>

```js
for (i = 0; i < 10; j++) { // Noncompliant
  // ...
  i++;
}
```
<h3>Compliant solution</h3>

```js
for (i = 0; i < 10; i++, j++) {
  // ...
}
```
<p>Or</p>

```js
for (i = 0; i < 10; i++) {
  // ...
  j++;
}
```