<h2>Why is this an issue?</h2>
<p><code>undefined</code> is the value you get for variables and properties which have not yet been created. Use the same value to reset an existing
variable and you lose the ability to distinguish between a variable that exists but has no value and a variable that does not yet exist. Instead,
<code>null</code> should be used, allowing you to tell the difference between a property that has been reset and one that was never created.</p>
<h3>Noncompliant code example</h3>

```js
var myObject = {};

// ...
myObject.fname = undefined;  // Noncompliant
// ...

if (myObject.lname == undefined) {
  // property not yet created
}
if (myObject.fname == undefined) {
  // no real way of knowing the true state of myObject.fname
}
```
<h3>Compliant solution</h3>

```js
var myObject = {};

// ...
myObject.fname = null;
// ...

if (myObject.lname == undefined) {
  // property not yet created
}
if (myObject.fname == undefined) {
  // no real way of knowing the true state of myObject.fname
}
```