<h2>Why is this an issue?</h2>
<p>JavaScript has the <code>new</code> keyword that is used in conjunction with constructor functions to create new instances of objects. When you use
the <code>new</code> keyword with a function, it signifies that the function is intended to be used as a constructor function to create objects.</p>
<p>Any function can be used as a constructor function by convention. Constructor functions are used to create new objects with the same structure or
properties. They are typically named with an initial capital letter to distinguish them from regular functions.</p>

```js
function Person(name, age) {
  this.name = name;
  this.age = age;
}
```
<p>To create a new instance of an object using the constructor function, you use the <code>new</code> keyword before the function call.</p>

```js
const person1 = new Person('Alice', 30);
const person2 = new Person('Bob', 25);
```
<p>Constructor functions, which create new object instances, must only be called with <code>new</code>. Non-constructor functions must not. Mixing
these two usages could lead to unexpected results at runtime.</p>

```js
function getNum() {
  return 5;
}

function Num(numeric, alphabetic) {
  this.numeric = numeric;
  this.alphabetic = alphabetic;
}

const num1 = getNum();
const num2 = new getNum(); // Noncompliant: An empty object is returned, not 5

const obj1 = new Num();
const obj2 = Num(); // Noncompliant: undefined is returned, not an object
```
<p>The rule checks that the <code>new</code> operator is consistently used with each function’s invocations, meaning for all invocations or none.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/new"><code>new</code> operator</a> </li>
</ul>