<h2>Why is this an issue?</h2>
<p>If the class declaration does not include a constructor, one is automatically created, so there is no need to provide an empty constructor, or one
that just delegates to the parent class.</p>

```js
class Foo {
    constructor() {}  // Noncompliant, empty
}

class Bar extends Foo {
    constructor(params) { // Noncompliant: just delegates to the parent
        super(params);
    }
}
```
<p>Instead, you can safely remove the empty constructor without affecting the functionality.</p>

```js
class Foo {}

class Bar extends Foo {}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/constructor">constructor</a> </li>
</ul>