<h2>Why is this an issue?</h2>
<p>Parentheses can disambiguate the order of operations in complex expressions and make the code easier to understand.</p>

```kotlin
a = (b * c) + (d * e); // Compliant: the intent is clear.
```
<p>Redundant parentheses are parenthesis that do not change the behavior of the code, and do not clarify the intent. They can mislead and complexify
the code. They should be removed.</p>
<h3>Noncompliant code example</h3>

```kotlin
val x = ((y / 2 + 1))  // Noncompliant

if (a && ((x + y > 0))) {  // Noncompliant
  return ((x + 1))  // Noncompliant
}
```
<h3>Compliant solution</h3>

```kotlin
val x = (y / 2 + 1)

if (a && (x + y > 0)) {
  return (x + 1)
}
```