<h2>Why is this an issue?</h2>
<p>In data classes, the default behavior of the <code>equals()</code> method is to check the equality by field values. This works well for primitive
fields or fields, whose type overrides <code>equals()</code>, but this behavior doesn’t work as expected for array fields.</p>
<p>By default, array fields are compared by their reference, so overriding <code>equals()</code> is highly recommended to ensure a deep equality
check. The same applies to the <code>hashcode()</code> method.</p>
<p>This rule reports an issue if a record class has an array field and is not overriding <code>equals()</code> or <code>hashcode()</code> methods.</p>
<h3>Noncompliant code example</h3>

```kotlin
data class Person(val names: Array<String>, val age: Int) {} // Noncompliant
```
<h3>Compliant solution</h3>

```kotlin
data class Person(val names: Array<String>, val age: Int) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Person

        if (!names.contentEquals(other.names)) return false
        if (age != other.age) return false

        return true
    }

    override fun hashCode(): Int {
        var result = names.contentHashCode()
        result = 31 * result + age
        return result
    }
}
```