<p>PHP session tokens are normally transmitted through HTTP cookies. However, for clients that do not support cookies and when the PHP
<code>session.use_trans_sid</code> setting is enabled, those tokens can be transmitted as URL parameters.</p>
<h2>Why is this an issue?</h2>
<p>GET URL parameter can be disclosed in a variety of ways:</p>
<ul>
  <li> Directly in a web browser address bar. </li>
  <li> In navigation history. </li>
  <li> In web servers or intermediate proxies log files. </li>
</ul>
<h3>What is the potential impact?</h3>
<p>Attackers with access to any of those disclosure locations will be able to see and steal a victim’s session token. They can then use it to log in
as the user, impersonate their account, and take advantage of their privileges.</p>
<p>Such an attack can be more or less severe depending on the victim’s privileges. Common security impacts range from data theft to application
takeover.</p>
<h4>Data theft</h4>
<p>Attackers with access to a compromised account will be able to disclose any information stored on it. This includes the Personally Identifiable
Information (PII) of the user.</p>
<p>The confidentiality of PII is a requirement from national security regulatory authorities in most countries. Insufficiently protecting this data
could have legal consequences and lead to fines or other prosecutions.</p>
<h4>Application takeover</h4>
<p>Attackers compromise the account of a high-privileged user could modify internal web application logic, disrupt workflows, or change other
application’s settings in a way that will give them full control over it.</p>
<p>Such an attack would lead to reputational damages and financial and legal consequences.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
; php.ini
session.use_trans_sid=1  ; Noncompliant
```
<h4>Compliant solution</h4>

```php
; php.ini
session.use_trans_sid=0
```
<h3>How does this work?</h3>
<p>The compliant code example disables the <code>session.use_trans_sid</code> setting.</p>
<p>Note that this parameter is off by default.</p>
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A05_2021-Security_Misconfiguration/">Top 10 2021 Category A5 - Security Misconfiguration</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A6_2017-Security_Misconfiguration">Top 10 2017 Category A6 - Security
  Misconfiguration</a> </li>
</ul>