<h2>Why is this an issue?</h2>
<p>The PHPUnit test runner does execute public methods defined within test classes that have a name starting with <em>"test"</em> or the
<em>@test</em> annotation. Methods that do not convey to this will not get executed.</p>
<p>This rule raises an issue on methods marked as test methods (by name or annotation) but do not have a public visibility. An issue is also raised on
public methods that are not marked as tests, do contain assertions, and are not called from within another discoverable test method within the class.
No issues are raised in abstract classes, or on public static method which provides data.</p>
<h3>Noncompliant code example</h3>

```php
class MyTest extends \PHPUnit\Framework\TestCase {
    private function testA() { // Noncompliant
        $this->assertTrue(getValue());
    }

    public function b() { // Noncompliant
        $this->assertTrue(getValue());
    }
}
```
<h3>Compliant solution</h3>

```php
class MyTest extends \PHPUnit\Framework\TestCase {
    public function testA() { // Compliant
        $this->assertTrue(getValue());
    }

    public function testB() {
        $this->b();
    }

    public function b() { // Compliant
        $this->assertTrue(getValue());
    }
}
```