<h2>Why is this an issue?</h2>
<p>TypeScript supports type inference, a mechanism that automatically infers the type of a variable based on its initial value. This means that if you
initialize a variable with a particular value, TypeScript will assume that this variable should always hold that type of value.</p>
<p>Unnecessarily verbose declarations and initializations make it harder to read the code and should be simplified. Therefore, type annotations should
be omitted from variable and parameter declarations when they can be easily inferred from the initialized or defaulted value.</p>
<h2>How to fix it</h2>
<p>Omit explicit type annotations in declarations whenever the type can be inferred from the context.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
const n: number = 1; // Noncompliant, "number" can be omitted

function foo(s: string = "") {} // Noncompliant, "string" can be omitted

class Bar {
  b: boolean = true;  // Noncompliant, "boolean" can be omitted
}
```
<h4>Compliant solution</h4>

```ts
const n = 1;

function foo(s = "") {}

class Bar {
  b = true;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/type-inference.html">Type Inference</a> </li>
</ul>