<h2>Why is this an issue?</h2>
<p>When a collection is empty with absolute certainty, it makes no sense to access or iterate it. Doing so can lead to unexpected behavior or errors
in the code. The most common cause is that population was accidentally omitted or removed.</p>

```ts
const strings = [];

if (strings.includes("foo")) {}  // Noncompliant: strings is always empty

for (const str of strings) {}  // Noncompliant

strings.forEach(str => doSomething(str)); // Noncompliant
```
<p>Make sure your code provides some way to populate the collection if their elements are to be accessed.</p>

```ts
const strings = [];

strings.push("foo");

if (strings.includes("foo")) {}

for (const str of strings) {}

strings.forEach(str => doSomething(str));
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array">Array</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols#the_iterable_protocol">Iterable
  protocol</a> </li>
</ul>