<h2>Why is this an issue?</h2>
<p>When using JSX the component children should be passed between opening and closing tags. Passing children in a <code>children</code> prop may work
sometimes, but will lead to errors if children are passed both as nested components and <code>children</code> prop at the same time.</p>
<p>When not using JSX, the children should be passed to <code>createElement()</code> method as extra arguments after the <code>props</code>
object.</p>

```ts
<div children='Children' />
<Foo children={<Bar />} />

React.createElement("div", { children: 'Children' })
```
<p>To fix the code, remove the <code>children</code> prop and pass the children between opening and closing JSX tags or as extra arguments to
<code>createElement()</code> function.</p>

```ts
<div>Children</div>
<Foo><Bar /></Foo>

React.createElement("div", {}, 'Children');
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn/passing-props-to-a-component">Passing Props to a Component</a> </li>
</ul>