<h2>Why is this an issue?</h2>
<p><code>alt</code> attributes, also known as "alt tags" or "alt descriptions," are used to specify alternative text that is rendered when an image
cannot be displayed. They are crucial for improving web accessibility, as they provide a text description of images for users who rely on screen
readers.</p>
<p>Screen readers announce the presence of an <code>&lt;img&gt;</code> element and read its <code>alt</code> attribute aloud to describe the image. If
the <code>alt</code> attribute includes words like "image", "picture", or "photo", it leads to redundancy as the screen reader would repeat "image".
For instance, an <code>alt</code> attribute like "image of a sunrise" would be read as "Image, image of a sunrise", unnecessarily repeating
"image".</p>
<p>Instead, the <code>alt</code> attribute should focus on describing the content of the image, not the fact that it is an image. This makes the
browsing experience more efficient and enjoyable for users of screen readers, as they receive a concise and meaningful description of the image
without unnecessary repetition.</p>
<h2>How to fix it</h2>
<p>To fix this issue, you should revise the <code>alt</code> attribute of your <code>&lt;img&gt;</code> elements to remove any instances of the words
"image", "picture", or "photo". Instead, provide a concise and accurate description of the image content that adds value for users who cannot see the
image.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function MyImage() {
    return <img src="sunrise.jpg" alt="image of a sunrise" />; // Noncompliant: "Image, image of a sunrise"
}
```
<h4>Compliant solution</h4>

```ts
function MyImage() {
    return <img src="sunrise.jpg" alt="a sunrise over a mountain range" />;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/img">img element</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/API/HTMLImageElement/alt">alt property</a> </li>
  <li> WebAIM - <a href="https://webaim.org/techniques/alttext/">Alternative Text</a> </li>
</ul>