Classes should not have public attributes.

# Why is This a Problem?
Classes should not have public attributes as this violates encapsulation.

## Exceptions
This rule does not apply to constants and to attributes in structs.

# How Can I Resolve This?
Avoid POD ("Plain Old Data") classes, for which structs should be used.
Grant public access to as few as possible variables.
If a member has to be accessed from outside the class, provide accessors (getter and setter methods) for the attribute and make the attribute itself private.

## Example (Before)
```cpp
class Circle {
  public: 
    double radius;
    double area;
    double circumference;
};
```

## Example (After)
```cpp
class Circle {
  public:
    void setRadius(double r);
    double getRadius();
    double getArea();
    double getCircumference();

  private:
    double radius;
};

void Circle::setRadius(double r) {
  radius = r;
}

double Circle::getRadius() {
  return radius;
}

double Circle::getArea() {
  return 3.141593 * radius * radius;
}

double Circle::getCircumference() {
  return 2 * 3.141593 * radius;
}
```
