The inclusion of header files should always be guarded by preprocessor macros.
Otherwise, unguarded header files may be included several times.

# Why is This a Problem?
When including headers without any kind of protection, the code from the headers is blindly copied into the respective file.
If a file includes several headers, this can lead to identical code being included and subsequently cause compile errors.

# How Can I Resolve This?
The inclusion of header files should be guarded by preprocessor macros.
Note that many compilers support the `#pragma once` directive for this purpose.
Using this directive is discouraged though since it is not part of the C++ standard and is not portable.

## Example (Before)
a.h:
```cpp
class A {
  int a;
};
```

b.h:
```cpp
#include "a.h"
class B {
  int b;
};
```

main.cpp:
```cpp
#include "a.h"
#include "b.h"
int main() {
  /* ... */
}
```
Since both, the direct inclusion of `a.h` and the indirect inclusion of `a.h` via the import of `b.h` lead to the inclusion of `Class A`, the program will yield a compile error.

## Example (After)
a.h:
```cpp
#ifndef A_H
#define A_H
class A {
  int a;
};
#endif
```

b.h:
```cpp
#ifndef B_H
#define B_H
#include "a.h"
class B {
  int b;
};
#endif
```

main.cpp:
```cpp
#include "a.h"
#include "b.h"
int main() {
  /* ... */
}
```
