<h2>Why is this an issue?</h2>
<p>While not mandatory, using the <code>@Override</code> annotation on compliant methods improves readability by making it explicit that methods are
overridden.</p>
<p>A compliant method either overrides a parent method or implements an interface or abstract method.</p>
<h3>Noncompliant code example</h3>

```java
class ParentClass {
  public boolean doSomething(){/*...*/}
}
class FirstChildClass extends ParentClass {
  public boolean doSomething(){/*...*/}  // Noncompliant
}
```
<h3>Compliant solution</h3>

```java
class ParentClass {
  public boolean doSomething(){/*...*/}
}
class FirstChildClass extends ParentClass {
  @Override
  public boolean doSomething(){/*...*/}  // Compliant
}
```
<h3>Exceptions</h3>
<p>This rule does not raise issues when overriding methods from <code>Object</code> (eg: <code>equals()</code>, <code>hashCode()</code>,
<code>toString()</code>, …​).</p>