/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Preconditions;
import com.teamscale.core.rest.client.converter.IBodyConverterProfilingMonitor;
import com.teamscale.core.rest.client.converter.RequestBodyConverter;
import com.teamscale.core.rest.client.converter.ResponseBodyConverter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.jspecify.annotations.NonNull;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class ConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;
    private final List<BiConsumerWithException<ResponseBody, Type, IOException>> customResponseValidators;
    private final IBodyConverterProfilingMonitor profiler;

    public static ConverterFactory create(ObjectMapper mapper, List<BiConsumerWithException<ResponseBody, Type, IOException>> customResponseValidators, IBodyConverterProfilingMonitor profiler) {
        Preconditions.checkNotNull((Object)mapper);
        return new ConverterFactory(mapper, customResponseValidators, profiler);
    }

    private ConverterFactory(ObjectMapper mapper, List<BiConsumerWithException<ResponseBody, Type, IOException>> customResponseValidators, IBodyConverterProfilingMonitor profiler) {
        this.mapper = mapper;
        this.customResponseValidators = customResponseValidators;
        this.profiler = profiler;
    }

    public Converter<ResponseBody, ?> responseBodyConverter(@NonNull Type type, Annotation @NonNull [] annotations, @NonNull Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new ResponseBodyConverter(type, reader, this.customResponseValidators, this.profiler);
    }

    public Converter<?, RequestBody> requestBodyConverter(@NonNull Type type, Annotation @NonNull [] parameterAnnotations, Annotation @NonNull [] methodAnnotations, @NonNull Retrofit retrofit) {
        return new RequestBodyConverter(this.mapper);
    }
}

