/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.MDLSection;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.builder.SimulinkModelBuilder;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.util.SimulinkUtils;

class SimulinkLineBuilder {
    private static final Logger LOGGER = LogManager.getLogger();
    private final boolean preserveUnconnectedLines;
    private final boolean isSlx;
    private static final Pattern SID_PATTERN = Pattern.compile("[\\d]+(:+[\\d]+)*");

    public SimulinkLineBuilder(ModelBuildingParameters modelBuildingParameters, boolean isSlx) {
        this.preserveUnconnectedLines = modelBuildingParameters.isPreserveUnconnectedLines();
        this.isSlx = isSlx;
    }

    public void buildLines(MDLSection section, SimulinkBlock simulinkBlock) throws SimulinkModelBuildingException {
        for (MDLSection line : section.getSubSections("Line")) {
            this.buildLine(line, simulinkBlock);
        }
    }

    private void buildLine(MDLSection lineSection, SimulinkBlock simulinkBlock) throws SimulinkModelBuildingException {
        SimulinkOutPort sourcePort = this.determineSrcPort(lineSection, simulinkBlock);
        if (sourcePort == null && !this.preserveUnconnectedLines) {
            return;
        }
        String lineName = lineSection.getParameter("Name");
        if (!lineSection.hasSubSections("Branch")) {
            SimulinkInPort dstPort = this.determineDstPort(lineSection, simulinkBlock);
            if (dstPort == null && !this.preserveUnconnectedLines) {
                return;
            }
            SimulinkLine line = new SimulinkLine(sourcePort, dstPort, simulinkBlock);
            SimulinkLineBuilder.addLineParameters(line, lineSection);
            if (lineName != null) {
                line.setParameter("Name", lineName);
            }
            return;
        }
        this.completeLine(lineSection, sourcePort, simulinkBlock);
    }

    private void completeLine(MDLSection lineSection, SimulinkOutPort sourcePort, SimulinkBlock simulinkBlock) throws SimulinkModelBuildingException {
        boolean destFound = false;
        Iterator<MDLSection> iterator = lineSection.getLeafSections("Branch").iterator();
        while (iterator.hasNext()) {
            MDLSection branchSection;
            if (this.preserveUnconnectedLines || branchSection.hasParameter("DstBlock")) {
                SimulinkInPort destPort = this.determineDstPort(branchSection, simulinkBlock);
                if (destPort == null && !this.preserveUnconnectedLines) continue;
                SimulinkLine line = new SimulinkLine(sourcePort, destPort, simulinkBlock);
                for (branchSection = iterator.next(); branchSection != lineSection; branchSection = branchSection.getParentSection()) {
                    SimulinkLineBuilder.addLineParameters(line, branchSection);
                }
                SimulinkLineBuilder.addLineParameters(line, lineSection);
                destFound = true;
                continue;
            }
            LOGGER.info(String.valueOf(branchSection) + " is a leave branch without destination block. Ignoring branch.");
        }
        if (!destFound && !this.preserveUnconnectedLines) {
            LOGGER.info(String.valueOf(lineSection) + " in block " + String.valueOf(simulinkBlock) + " has no destination. Ignoring line.");
        }
    }

    private static void addLineParameters(SimulinkLine line, MDLSection branchSection) {
        String currentLabels = line.getDeclaredParameter("Labels");
        SimulinkModelBuilder.addParameters(line, branchSection);
        if (currentLabels == null) {
            return;
        }
        String prependedPoints = branchSection.getParameter("Points");
        int prependCount = 0;
        if (prependedPoints != null) {
            prependCount = (StringUtils.countCharacter((String)prependedPoints, (char)',') + 1) / 2;
        }
        int[] currentValueArray = SimulinkUtils.getIntParameterArray(currentLabels);
        for (int i = 0; i < currentValueArray.length; i += 2) {
            if (currentValueArray[i] < 0) continue;
            int n = i;
            currentValueArray[n] = currentValueArray[n] + prependCount;
        }
        IntStream valueStream = Arrays.stream(currentValueArray);
        String sectionLabels = branchSection.getParameter("Labels");
        if (sectionLabels != null) {
            int[] sectionValueArray = SimulinkUtils.getIntParameterArray(sectionLabels);
            valueStream = IntStream.concat(Arrays.stream(sectionValueArray), valueStream);
        }
        line.setParameter("Labels", valueStream.mapToObj(Integer::toString).collect(Collectors.joining(", ", "[", "]")));
    }

    private SimulinkOutPort determineSrcPort(MDLSection section, SimulinkBlock simulinkBlock) throws SimulinkModelBuildingException {
        return (SimulinkOutPort)this.determinePort(section, simulinkBlock, true);
    }

    private SimulinkInPort determineDstPort(MDLSection section, SimulinkBlock simulinkBlock) throws SimulinkModelBuildingException {
        return (SimulinkInPort)this.determinePort(section, simulinkBlock, false);
    }

    private SimulinkPortBase determinePort(MDLSection section, SimulinkBlock simulinkBlock, boolean srcPort) throws SimulinkModelBuildingException {
        String blockParameter = srcPort ? "SrcBlock" : "DstBlock";
        SimulinkBlock targetBlock = this.getSubBlockByParameter(section, simulinkBlock, blockParameter);
        if (targetBlock == null) {
            return null;
        }
        String portParameter = srcPort ? "SrcPort" : "DstPort";
        String portIndex = section.getParameter(portParameter);
        if (portIndex.toLowerCase().contains("lconn") || portIndex.toLowerCase().contains("rconn")) {
            LOGGER.warn("The block '" + simulinkBlock.getName() + "' in '" + simulinkBlock.getModel().getUniformPath() + "' contains lconn/rconn port '" + portIndex + "'. Teamscale does not support these ports.");
            return null;
        }
        SimulinkPortBase targetPort = srcPort ? targetBlock.getOutPort(portIndex) : targetBlock.getInPort(portIndex);
        if (targetPort == null) {
            LOGGER.warn(String.valueOf(section) + " refers to unknown port " + portIndex + ".");
            return null;
        }
        return targetPort;
    }

    private SimulinkBlock getSubBlockByParameter(MDLSection section, SimulinkBlock parentBlock, String parameterName) throws SimulinkModelBuildingException {
        String subBlockName = section.getParameter(parameterName);
        if (subBlockName == null) {
            if (!this.preserveUnconnectedLines) {
                LOGGER.info(String.valueOf(section) + " in block " + String.valueOf(parentBlock) + " has no " + parameterName + ". Ignoring line.");
            }
            return null;
        }
        boolean isSID = this.isSlx && SID_PATTERN.matcher(subBlockName).matches();
        SimulinkBlock resultBlock = isSID ? parentBlock.getSubBlockBySID(subBlockName) : parentBlock.getSubBlock(subBlockName);
        if (resultBlock == null) {
            throw new SimulinkModelBuildingException(String.valueOf(section) + " refers to unknown " + parameterName + " block " + subBlockName + ".");
        }
        return resultBlock;
    }
}

