/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.commons.visitor.IVisitor;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.builder.SimulinkEnumeratedType;
import org.conqat.lib.simulink.builder.SimulinkModelBuilder;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkFunctionConnector;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.datahandler.ESimulinkBlockType;
import org.conqat.lib.simulink.model.datahandler.simulink.MaskObjectParameter;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SimulinkUtils {
    private static final String PORT_PARAMETER_DEFAULT = "1";
    public static final String SIMULINK_ID_SEPARATOR = "/";
    public static final String STATEFLOW_NODE_SEPARATOR = ".";
    private static final Pattern SIMULINK_ID_SPLIT_PATTERN = Pattern.compile("[^/]/[^/]");
    public static final Set<String> FLOATING_POINT_TYPES = CollectionUtils.asHashSet((Object[])new String[]{"double", "single", "half"});
    private static final Function<SimulinkInPort, String> BLOCK_IDENTIFIER_EXTRACTOR = port -> port.getBlock().getName() + port.getBlock().getParameter("SID");
    public static final Comparator<SimulinkLine> LINE_BY_DST_PORT_COMPARATOR = Comparator.comparing(SimulinkLine::getDstPort, Comparator.nullsFirst(Comparator.comparing(BLOCK_IDENTIFIER_EXTRACTOR).thenComparing(SimulinkPortBase::getIndex)));

    public static void copyParameters(ParameterizedElement source, ParameterizedElement target) {
        for (String name : source.getParameterNames()) {
            target.setParameter(name, source.getParameter(name));
        }
    }

    public static Map<String, SimulinkBlock> createIdToNodeMap(SimulinkBlock block) {
        final HashMap<String, SimulinkBlock> map = new HashMap<String, SimulinkBlock>();
        SimulinkUtils.visitDepthFirst(block, new IVisitor<SimulinkBlock, NeverThrownRuntimeException>(){

            public void visit(SimulinkBlock block) {
                map.put(block.getId(), block);
            }
        });
        return map;
    }

    public static String buildId(SimulinkElementBase parent, String localName) {
        if (parent != null) {
            return parent.getId() + SIMULINK_ID_SEPARATOR + SimulinkUtils.escapeSlashes(localName);
        }
        return SimulinkUtils.escapeSlashes(localName);
    }

    public static String escapeSlashes(String string) {
        return string.replace(SIMULINK_ID_SEPARATOR, "//");
    }

    public static String removeEscapedSlashes(String name) {
        return name.replace("//", SIMULINK_ID_SEPARATOR);
    }

    public static int[] getIntParameterArray(String parameter) {
        String[] parts = SimulinkUtils.getStringParameterArray(parameter);
        int[] result = new int[parts.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(parts[i]);
        }
        return result;
    }

    public static double[] getDoubleParameterArray(String parameter) {
        String[] parts = SimulinkUtils.getStringParameterArray(parameter);
        double[] result = new double[parts.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Double.parseDouble(parts[i]);
        }
        return result;
    }

    public static String[] getStringParameterArray(String parameter) {
        if (parameter == null) {
            return new String[0];
        }
        String content = parameter.substring(1, parameter.length() - 1);
        if (StringUtils.isEmpty((String)content)) {
            return new String[0];
        }
        return content.split("[,; ] *");
    }

    public static List<String> splitSimulinkId(String id) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = SIMULINK_ID_SPLIT_PATTERN.matcher(id);
        int begin = 0;
        while (matcher.find(begin)) {
            result.add(SimulinkUtils.removeEscapedSlashes(id.substring(begin, matcher.start() + 1)));
            begin = matcher.end() - 1;
        }
        result.add(SimulinkUtils.removeEscapedSlashes(id.substring(begin)));
        return result;
    }

    public static String createSimulinkId(Iterable<String> names) {
        StringBuilder result = new StringBuilder();
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            String name = it.next();
            CCSMAssert.isFalse((boolean)SimulinkUtils.startsOrEndsWithSeparator(name), (String)"Simulink names cannot start or end with a slash.");
            result.append(SimulinkUtils.escapeSlashes(name));
            if (!it.hasNext()) continue;
            result.append(SIMULINK_ID_SEPARATOR);
        }
        return result.toString();
    }

    public static <X extends Exception> void visitDepthFirst(SimulinkBlock block, IVisitor<SimulinkBlock, X> visitor) throws X {
        visitor.visit((Object)block);
        for (SimulinkBlock child : block.getSubBlocks()) {
            SimulinkUtils.visitDepthFirst(child, visitor);
        }
    }

    @Deprecated
    public static List<SimulinkBlock> listBlocksDepthFirst(SimulinkBlock block) {
        ArrayList<SimulinkBlock> result = new ArrayList<SimulinkBlock>();
        SimulinkUtils.visitDepthFirst(block, result::add);
        return result;
    }

    public static List<SimulinkBlock> listBlocksDepthFirst(SimulinkBlock block, boolean includeInvisible, boolean includeCommented) {
        return SimulinkUtils.listBlocksDepthFirst(block, includeInvisible, includeCommented, (Predicate<SimulinkBlock>)Predicates.alwaysTrue());
    }

    public static List<SimulinkBlock> listBlocksDepthFirst(SimulinkBlock block, boolean includeInvisible, boolean includeCommented, Predicate<SimulinkBlock> includeBlock) {
        ArrayList<SimulinkBlock> result = new ArrayList<SimulinkBlock>();
        ArrayDeque<SimulinkBlock> waitlist = new ArrayDeque<SimulinkBlock>();
        waitlist.add(block);
        while (!waitlist.isEmpty()) {
            SimulinkBlock current = (SimulinkBlock)waitlist.pop();
            if (!includeInvisible && !SimulinkUtils.isUserVisible(current)) {
                waitlist.addAll((Collection<SimulinkBlock>)current.getSubBlocks());
                continue;
            }
            if (!includeCommented && SimulinkUtils.isCommentedBlock(current)) continue;
            if (includeBlock.test(current)) {
                result.add(current);
            }
            current.getSubBlocks().forEach(waitlist::push);
        }
        return result;
    }

    @Deprecated
    public static List<SimulinkBlock> listOnlyVisibleBlocksDepthFirst(SimulinkBlock block) {
        return SimulinkUtils.listBlocksDepthFirst(block, false, false);
    }

    public static boolean isUserVisible(SimulinkBlock block) {
        if (SimulinkUtils.isSubsystem(block)) {
            return true;
        }
        SimulinkBlock parent = block.getParent();
        if (parent == null) {
            return true;
        }
        if ("Sigbuilder block".equals(parent.getParameter("Mask.Type"))) {
            return false;
        }
        return !SimulinkUtils.isBlockWhichHidesSimulinkChildren(parent);
    }

    public static boolean isUserVisible(SimulinkLine signalLine) {
        return !SimulinkUtils.isBlockWhichHidesSimulinkChildren(signalLine.getContainer());
    }

    private static boolean isBlockWhichHidesSimulinkChildren(SimulinkBlock block) {
        return block instanceof StateflowBlock;
    }

    public static boolean isCommentedBlock(SimulinkBlock block) {
        String parameterValue = block.getParameter("commented");
        if (parameterValue == null) {
            parameterValue = block.getParameter("Commented");
        }
        return "on".equals(parameterValue) || "through".equals(parameterValue);
    }

    @Deprecated
    public static List<SimulinkBlock> listBlocksOfTypesDepthFirst(SimulinkBlock block, Set<String> types) {
        ArrayList<SimulinkBlock> result = new ArrayList<SimulinkBlock>();
        SimulinkUtils.visitDepthFirst(block, element -> {
            if (types.contains(element.getType()) || element.getSourceType() != null && types.contains(element.getSourceType())) {
                result.add((SimulinkBlock)element);
            }
        });
        return result;
    }

    public static List<SimulinkBlock> listBlocksOfTypesDepthFirst(SimulinkBlock block, Set<String> types, boolean includeInvisible, boolean includeCommented) {
        Predicate<SimulinkBlock> filterByType = currentBlock -> types.contains(currentBlock.getType());
        return SimulinkUtils.listBlocksDepthFirst(block, includeInvisible, includeCommented, filterByType);
    }

    public static int getBlockCount(SimulinkBlock model) {
        return SimulinkUtils.listBlocksDepthFirst(model, false, false).size() - 1;
    }

    public static Set<SimulinkBlock> calculateParentSet(Collection<SimulinkBlock> blocks) {
        IdentityHashSet parents = new IdentityHashSet();
        Iterator<SimulinkBlock> iterator = blocks.iterator();
        while (iterator.hasNext()) {
            SimulinkBlock block;
            SimulinkModel model = block.getModel();
            for (block = iterator.next(); block != model; block = block.getParent()) {
                parents.add(block);
            }
        }
        return parents;
    }

    public static int countSubBlocks(SimulinkBlock block) {
        BlockAndLineCounter counter = new BlockAndLineCounter();
        SimulinkUtils.visitDepthFirst(block, counter);
        return counter.blockCount - 1;
    }

    public static int countLines(SimulinkBlock block) {
        BlockAndLineCounter counter = new BlockAndLineCounter();
        for (SimulinkBlock child : block.getSubBlocks()) {
            SimulinkUtils.visitDepthFirst(child, counter);
        }
        return counter.lineCount;
    }

    public static Optional<SimulinkBlock> findOutPortBlock(SimulinkBlock parent, String index) {
        for (SimulinkBlock block : parent.getSubBlocks()) {
            if (!SimulinkUtils.isOutport(block) || !index.equals(block.getParameter("Port"))) continue;
            return Optional.of(block);
        }
        return Optional.empty();
    }

    public static List<SimulinkBlock> findInPortBlocks(SimulinkBlock parent, String index) {
        ArrayList<SimulinkBlock> inports = new ArrayList<SimulinkBlock>();
        for (SimulinkBlock block : parent.getSubBlocks()) {
            if (!SimulinkUtils.isInport(block) || !index.equals(SimulinkUtils.getPortParameterOrDefault(block))) continue;
            inports.add(block);
        }
        return inports;
    }

    public static String getPortParameterOrDefault(SimulinkBlock block) {
        String port = block.getParameter("Port");
        if (port == null && (SimulinkUtils.isInport(block) || SimulinkUtils.isOutport(block))) {
            return PORT_PARAMETER_DEFAULT;
        }
        return port;
    }

    public static @Nullable String getPropagatedSignalName(SimulinkOutPort srcPort, @Nullable SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        String propagatedSignal = srcPort.getParameter("PropagatedSignals");
        if (propagatedSignal != null) {
            return propagatedSignal;
        }
        SimulinkBlock srcBlock = srcPort.getBlock();
        if (srcBlock == null || propagatedSignalLabels == null) {
            return null;
        }
        return propagatedSignalLabels.getPropagatedOutputSignalLabelsForBlock(srcBlock, srcPort.getIndex());
    }

    public static String buildBlockLocationForErrorReporting(SimulinkBlock simulinkBlock) {
        String pathInModel = simulinkBlock.buildQualifiedName();
        String uniformPath = simulinkBlock.getModel().getUniformPath();
        return uniformPath + ":" + pathInModel;
    }

    public static SimulinkBlock getLowestCommonAncestor(SimulinkBlock block1, SimulinkBlock block2) {
        CCSMAssert.isTrue((block1.getModel() == block2.getModel() ? 1 : 0) != 0, (String)"Both blocks must be in same model!");
        Set<SimulinkBlock> parentSet1 = SimulinkUtils.calculateParentSet(Collections.singletonList(block1));
        while (block2 != null) {
            if (parentSet1.contains(block2)) {
                return block2;
            }
            block2 = block2.getParent();
        }
        return block1.getModel();
    }

    public static <T extends SimulinkElementBase> List<T> sortById(Collection<T> blocks) {
        return CollectionUtils.sort(blocks, (Comparator)new Comparator<T>(){

            @Override
            public int compare(T block1, T block2) {
                return ((SimulinkElementBase)block1).getId().compareTo(((SimulinkElementBase)block2).getId());
            }
        });
    }

    public static SimulinkObject findObjectByClass(SimulinkElementBase element, String className) {
        if (element == null) {
            return null;
        }
        for (SimulinkObject object : element.getObjects()) {
            if (!className.equals(object.getParameter("ClassName")) && !className.equals(object.getParameter("$ClassName"))) continue;
            return object;
        }
        return null;
    }

    public static boolean startsOrEndsWithSeparator(String name) {
        return name.startsWith(SIMULINK_ID_SEPARATOR) || name.endsWith(SIMULINK_ID_SEPARATOR);
    }

    public static boolean isInport(SimulinkBlock block) {
        return block.isOfType("Inport") || block.isOfType("InportShadow");
    }

    public static boolean isOutport(SimulinkBlock block) {
        return block.isOfType("Outport");
    }

    public static List<SimulinkBlock> getAllInportPortBlocks(SimulinkBlock parent) {
        return SimulinkUtils.getAllPortBlocks(parent, true);
    }

    public static List<SimulinkBlock> getAllOutportPortBlocks(SimulinkBlock parent) {
        return SimulinkUtils.getAllPortBlocks(parent, false);
    }

    private static List<SimulinkBlock> getAllPortBlocks(SimulinkBlock parent, boolean inPort) {
        ArrayList<SimulinkBlock> portBlocks = new ArrayList<SimulinkBlock>();
        for (SimulinkBlock block : parent.getSubBlocks()) {
            if (inPort && !SimulinkUtils.isInport(block) || !inPort && !SimulinkUtils.isOutport(block)) continue;
            portBlocks.add(block);
        }
        return portBlocks;
    }

    public static boolean isRoundSum(SimulinkBlock block) {
        return block.isOfTypeOrReferenceToBlockOfType("Sum") && "round".equals(block.getParameter("IconShape"));
    }

    public static boolean isRoundFunctionCallSplitBlock(SimulinkBlock block) {
        return block.isOfType("FunctionCallSplit") && !"distinctive".equals(block.getParameter("IconShape"));
    }

    public static boolean isFunctionCallSplitBlockWithReverseOutputLayout(SimulinkBlock block) {
        String outputPortLayout = block.getParameter("OutputPortLayout");
        return block.isOfType("FunctionCallSplit") && (outputPortLayout == null || "reverse".equals(outputPortLayout));
    }

    public static boolean isFunctionCallSubSystem(SimulinkBlock block) {
        if (!block.isOfType("SubSystem")) {
            return false;
        }
        Optional<SimulinkBlock> triggerBlock = block.getSubBlocks().stream().filter(child -> child.isOfType("TriggerPort")).findFirst();
        if (!triggerBlock.isPresent() || !"on".equals(triggerBlock.get().getParameter("IsSimulinkFunction"))) {
            return false;
        }
        return "function-call".equals(triggerBlock.get().getParameter("TriggerType"));
    }

    public static boolean isMaskedSubsystem(SimulinkBlock block) {
        return MaskObjectParameter.extractFromBlock(block) != null;
    }

    public static String replaceSimulinkLineBreaks(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("\\\\?\\\\n", StringUtils.LINE_SEPARATOR);
    }

    public static String getObjectId(SimulinkObject object) {
        String id = object.getParameter("$ObjectID");
        if (id != null) {
            return id;
        }
        return object.getParameter("ObjectID");
    }

    public static ESimulinkBlockType determineBlockType(SimulinkBlock block) {
        String iconShape;
        if (block.getParent() == null) {
            return ESimulinkBlockType.SUB_SYSTEM;
        }
        if (block.isOfType("Sum") && ((iconShape = block.getParameter("IconShape")) == null || iconShape.contains("round"))) {
            return ESimulinkBlockType.SUM_ROUND;
        }
        if (block.isOfType("Reference")) {
            return ESimulinkBlockType.getReferenceBlockEnumType(block.getSourceType(), block.getSourceBlockName());
        }
        try {
            String pattern = "([A-Z])";
            String blockType = block.getType();
            String blockTypeInEnumForm = blockType.replaceAll(pattern, "_$1").substring(1).toUpperCase();
            return ESimulinkBlockType.valueOf(blockTypeInEnumForm);
        }
        catch (IllegalArgumentException e) {
            return ESimulinkBlockType.DEFAULT;
        }
    }

    public static Pair<SimulinkBlock, String> getBlockReferencedByFunctionCallerIn(SimulinkBlock block) {
        if (!block.isOfType("FunctionCaller")) {
            return null;
        }
        Optional<SimulinkObject> functionPort = block.getFunctionPort();
        boolean hasFunctionPort = functionPort.isPresent();
        if (!hasFunctionPort) {
            return null;
        }
        String functionCalls = functionPort.get().getParameter("Calls");
        while (hasFunctionPort) {
            block = block.getParent();
            hasFunctionPort = block.getFunctionPort().isPresent();
            Pair<SimulinkBlock, String> nestedFunctionConnectors = SimulinkUtils.checkFunctionConnectors(block, functionCalls);
            if (nestedFunctionConnectors == null) continue;
            return nestedFunctionConnectors;
        }
        return SimulinkUtils.checkFunctionConnectors(block, functionCalls);
    }

    private static Pair<SimulinkBlock, String> checkFunctionConnectors(SimulinkBlock block, String functionCalls) {
        SimulinkBlock parentBlock = block.getParent();
        if (parentBlock == null) {
            return null;
        }
        UnmodifiableSet<SimulinkFunctionConnector> connectors = parentBlock.getFunctionConnectors();
        if (connectors.size() == 0) {
            return null;
        }
        for (SimulinkFunctionConnector connector : connectors) {
            SimulinkBlock callerBlock = connector.getCallerBlock();
            if (callerBlock == null) continue;
            ArrayList<String> availableCalls = new ArrayList<String>();
            String functionConnectorCalls = connector.getCalls();
            if (functionConnectorCalls != null) {
                availableCalls.addAll(Arrays.asList(functionConnectorCalls.split(",")));
            }
            if (functionCalls == null || !availableCalls.contains(functionCalls)) continue;
            return new Pair((Object)connector.getFunctionBlock(), (Object)functionCalls);
        }
        return null;
    }

    public static boolean isVariantSubsystem(SimulinkBlock subsystem) {
        if (subsystem == null) {
            return false;
        }
        return subsystem.isOfType("SubSystem") && "on".equals(subsystem.getParameter("Variant"));
    }

    public static SimulinkBlock getActiveVariant(SimulinkBlock variantSubsystem) {
        if (!SimulinkUtils.isVariantSubsystem(variantSubsystem)) {
            return null;
        }
        String selectedLabel = variantSubsystem.getParameter("LabelModeActiveChoice");
        if (selectedLabel == null) {
            return null;
        }
        List activeVariants = CollectionUtils.filter(variantSubsystem.getSubBlocks(), block -> selectedLabel.equals(block.getParameter("VariantControl")));
        if (activeVariants.isEmpty()) {
            return null;
        }
        return (SimulinkBlock)activeVariants.get(0);
    }

    public static List<SimulinkBlock> getDisabledVariants(SimulinkBlock variantSubsystem) {
        ArrayList<SimulinkBlock> disabledVariants = new ArrayList<SimulinkBlock>();
        if (variantSubsystem == null || !variantSubsystem.isOfType("SubSystem") || !"on".equals(variantSubsystem.getParameter("Variant"))) {
            return disabledVariants;
        }
        SimulinkBlock activeVariant = SimulinkUtils.getActiveVariant(variantSubsystem);
        if (activeVariant == null) {
            return CollectionUtils.filter(variantSubsystem.getSubBlocks(), block -> block.isOfType("SubSystem"));
        }
        return CollectionUtils.filter(variantSubsystem.getSubBlocks(), block -> block.isOfType("SubSystem") && !block.getId().equals(activeVariant.getId()));
    }

    public static boolean isImmediateChildOfVariantSubsystem(SimulinkBlock block) {
        SimulinkBlock parent = block.getParent();
        return SimulinkUtils.isVariantSubsystem(parent);
    }

    public static boolean isFromBlock(SimulinkBlock block) {
        return block.isOfType("From");
    }

    public static boolean isLibraryReferenceBlock(SimulinkElementBase block) {
        String sourceBlock = block.getDeclaredParameter("SourceBlock");
        boolean notInternalReference = sourceBlock != null && !sourceBlock.startsWith("$bdroot");
        return block.getDeclaredParameter("LibraryVersion") != null && notInternalReference;
    }

    public static boolean referencesCustomLibrary(SimulinkBlock block) {
        if (!SimulinkUtils.isLibraryReferenceBlock(block)) {
            return false;
        }
        String sourceBlock = StringUtils.emptyIfNull((String)block.getSourceBlockName());
        if (SimulinkUtils.isLibraryReferenceBlock(block) && sourceBlock.startsWith("simulink/")) {
            return false;
        }
        String sourceModel = StringUtils.getFirstPart((String)sourceBlock, (String)SIMULINK_ID_SEPARATOR);
        if (sourceModel.equals(block.getModel().getName())) {
            return false;
        }
        String sourceBaseCode = block.getParameter("SourceProductBaseCode");
        return !"SL".equals(sourceBaseCode) && !"XP".equals(sourceBaseCode);
    }

    public static boolean isSubsystemReferenceBlock(SimulinkBlock block) {
        return block.isOfType("SubSystem") && !StringUtils.emptyIfNull((String)block.getParameter("ReferencedSubsystem")).isEmpty();
    }

    public static boolean isSimulinkModelPath(String path) {
        return StringUtils.endsWithOneOf((String)path, (String[])new String[]{".mdl", ".slx"});
    }

    public static boolean isSimulinkDataDictionary(String path) {
        return path.endsWith(".sldd");
    }

    public static String extractSimpleFileName(@NonNull String uniformPath) {
        CCSMAssert.isTrue((boolean)SimulinkUtils.isSimulinkModelPath(uniformPath), (String)"Referenced subsystem files must have a .slx or .mdl file type.");
        return StringUtils.removeLastPart((String)StringUtils.getLastPart((String)uniformPath, (char)'/'), (char)'.');
    }

    public static SimulinkModel parseModelFromByteArray(byte[] bytes, String uniformPath, Function<String, SimulinkModel> relatedModelAccessor) throws IOException, SimulinkModelBuildingException {
        try (SimulinkModelBuilder modelBuilder = new SimulinkModelBuilder(bytes, relatedModelAccessor, uniformPath);){
            SimulinkModel simulinkModel = modelBuilder.buildModel(new ModelBuildingParameters().setGuessMdlEncoding(true).setPreserveUnconnectedLines(true));
            return simulinkModel;
        }
    }

    public static List<String> getSimulinkParameterNames(SimulinkModel model) {
        return model.getObjects().stream().filter(object -> object.getParameter("type").equals("Parameter")).map(parameter -> parameter.getParameter("Name")).collect(Collectors.toList());
    }

    public static SimulinkBlock getConnectedBlock(SimulinkInPort inPort) {
        return Optional.ofNullable(inPort).map(SimulinkInPort::getLine).map(SimulinkLine::getSrcPort).map(SimulinkPortBase::getBlock).orElse(null);
    }

    public static @Nullable SimulinkOutPort getConnectedOutPort(SimulinkInPort inPort) {
        return Optional.ofNullable(inPort).map(SimulinkInPort::getLine).map(SimulinkLine::getSrcPort).orElse(null);
    }

    public static List<SimulinkBlock> getConnectedBlocks(SimulinkOutPort outPort) {
        return outPort.getLines().stream().map(SimulinkLine::getDstPort).map(SimulinkPortBase::getBlock).collect(Collectors.toList());
    }

    public static boolean inheritsDimension(SimulinkBlock block) {
        String portDimension = block.getParameter("PortDimensions");
        if (portDimension == null) {
            return SimulinkUtils.isInport(block) || SimulinkUtils.isOutport(block);
        }
        return "-1".equals(portDimension);
    }

    public static boolean isSubsystem(SimulinkBlock block) {
        return "SubSystem".equals(block.getType());
    }

    public static boolean isConditionallyExecutedSubsystem(SimulinkBlock block) {
        if (!SimulinkUtils.isSubsystem(block)) {
            return false;
        }
        Set directSubBlockTypes = CollectionUtils.mapToSet(block.getSubBlocks(), SimulinkBlock::getType);
        return directSubBlockTypes.contains("EnablePort") || directSubBlockTypes.contains("TriggerPort");
    }

    private static boolean isActionSubsystem(SimulinkBlock block) {
        if (!block.isOfType("SubSystem")) {
            return false;
        }
        Set directSubBlockTypes = CollectionUtils.mapToSet(block.getSubBlocks(), SimulinkBlock::getType);
        return directSubBlockTypes.contains("ActionPort");
    }

    public static boolean isConditionalSubsystem(SimulinkBlock block) {
        return SimulinkUtils.isConditionallyExecutedSubsystem(block) || SimulinkUtils.isActionSubsystem(block);
    }

    public static boolean isForOrWhileIteratorSubsystem(SimulinkBlock block) {
        if (!block.isOfType("SubSystem")) {
            return false;
        }
        if (block.getInPorts().isEmpty() || block.getOutPorts().isEmpty()) {
            return false;
        }
        for (SimulinkBlock subBlock : block.getSubBlocks()) {
            if (!subBlock.isOfType("ForIterator") && !subBlock.isOfType("WhileIterator")) continue;
            return true;
        }
        return false;
    }

    public static SimulinkInPort getInportFromSubsystemInportBlock(SimulinkBlock block) {
        CCSMAssert.isTrue((block.isOfType("Inport") && block.getParent().isOfType("SubSystem") ? 1 : 0) != 0, (String)"Called getInportFromSubsystemInportBlock on a block that is not an inport of a subsystem.");
        String port = block.getParameter("Port");
        return block.getParent().getInPorts().stream().filter(inPort -> inPort.getIndex().equals(port)).findFirst().orElse(null);
    }

    public static SimulinkBlock getSubsystemOutportBlockFromOutport(SimulinkOutPort outPort) {
        CCSMAssert.isTrue((boolean)outPort.getBlock().isOfType("SubSystem"), (String)"Called getOutportBlockFromSubsystemOutport on a block that is not an outport of a subsystem.");
        return outPort.getBlock().getSubBlocks().stream().filter(subblock -> subblock.isOfType("Outport") && Optional.ofNullable(subblock.getParameter("Port")).orElse(PORT_PARAMETER_DEFAULT).equals(outPort.getIndex())).findFirst().orElse(null);
    }

    public static boolean isNonVirtualSubsystem(SimulinkBlock block) {
        boolean isAtomicUnit = "on".equals(block.getParameter("TreatAsAtomicUnit"));
        return isAtomicUnit || SimulinkUtils.isConditionallyExecutedSubsystem(block);
    }

    public static SimulinkInPort resolveInportOfSubsystemInportBlock(SimulinkBlock inportBlock) {
        CCSMAssert.isTrue((boolean)SimulinkUtils.isInport(inportBlock), (String)"Called resolveInportOfSubsystemInportBlock with a block that is not of inport type");
        CCSMAssert.isTrue((inportBlock.getParent() != null && inportBlock.getParent().getType().equals("SubSystem") ? 1 : 0) != 0, (String)"Called resolveInportOfSubsystemInportBlock with a block that is not in a subsystem.");
        SimulinkBlock parent = inportBlock.getParent();
        String port = Optional.ofNullable(inportBlock.getParameter("Port")).orElse(PORT_PARAMETER_DEFAULT);
        return parent.getInPort(port);
    }

    public static SimulinkOutPort resolveOutportOfSubsystemOutportBlock(SimulinkBlock outportBlock) {
        CCSMAssert.isTrue((boolean)outportBlock.getType().equals("Outport"), (String)"Called resolveOutportOfSubsystemOutportBlock with a block that is not of outport type");
        CCSMAssert.isTrue((outportBlock.getParent() != null && outportBlock.getParent().getType().equals("SubSystem") ? 1 : 0) != 0, (String)"Called resolveOutportOfSubsystemOutportBlock with a block that is not in a subsystem.");
        SimulinkBlock parent = outportBlock.getParent();
        String port = Optional.ofNullable(outportBlock.getParameter("Port")).orElse(PORT_PARAMETER_DEFAULT);
        return parent.getOutPort(port);
    }

    public static SimulinkBlock findBlockBySidRecursive(SimulinkBlock ancestor, String simulinkID) {
        for (SimulinkBlock subBlock : SimulinkUtils.listBlocksDepthFirst(ancestor, true, true)) {
            if (!simulinkID.equals(subBlock.getParameter("SID"))) continue;
            return subBlock;
        }
        return null;
    }

    public static String getTypeOrSourceType(SimulinkBlock block) {
        if (block.isOfType("Reference")) {
            return block.getSourceType();
        }
        return block.getType();
    }

    public static Optional<ISimulinkDataDictionaryEntry> findDataDictionaryEntry(List<SimulinkDataDictionary> dataDictionaries, String dictionaryVariable) {
        return SimulinkUtils.findDataDictionaryEntry(dataDictionaries, dictionaryVariable, ISimulinkDataDictionaryEntry.class);
    }

    public static <T extends ISimulinkDataDictionaryEntry> Optional<T> findDataDictionaryEntry(List<SimulinkDataDictionary> dictionaries, String name, Class<T> type) {
        if (name == null) {
            return Optional.empty();
        }
        if (SimulinkEnumeratedType.class.equals(type) && name.contains(STATEFLOW_NODE_SEPARATOR)) {
            name = name.substring(0, name.indexOf(STATEFLOW_NODE_SEPARATOR));
        }
        for (SimulinkDataDictionary dictionary : dictionaries) {
            Optional<ISimulinkDataDictionaryEntry> entry = dictionary.findEntry(name);
            if (!entry.isPresent() || !type.isInstance(entry.get())) continue;
            return Optional.of(entry.get());
        }
        return Optional.empty();
    }

    public static <T extends ISimulinkDataDictionaryEntry> Set<String> getAllNamesOfDictionaryType(List<SimulinkDataDictionary> dictionaries, Class<T> type) {
        HashSet<String> result = new HashSet<String>();
        for (SimulinkDataDictionary dictionary : dictionaries) {
            Set names = dictionary.getEntries().stream().filter(type::isInstance).map(ISimulinkDataDictionaryEntry::getName).collect(Collectors.toSet());
            result.addAll(names);
        }
        return result;
    }

    public static String getAutosarObjectParameter(SimulinkModel model, SimulinkBlock block, String parameter) {
        for (SimulinkObject object : block.getObjects()) {
            String objectId = object.getParameter("ObjectID");
            if (objectId == null) continue;
            String referencedObjectId = objectId;
            if (objectId.contains(":")) {
                referencedObjectId = (String)StringUtils.splitAtLast((String)objectId, (char)':').getSecond();
            }
            return model.getParameter(String.format("AUTOSAR.%s.%s", referencedObjectId, parameter));
        }
        return null;
    }

    public static @NonNull String getFullName(@NonNull SimulinkBlock block) {
        SimulinkModel model = block.getModel();
        String blockIdSuffix = block.getId();
        return blockIdSuffix.replace(model.getName() + SIMULINK_ID_SEPARATOR, "");
    }

    private SimulinkUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static class BlockAndLineCounter
    implements IVisitor<SimulinkBlock, NeverThrownRuntimeException> {
        private int blockCount = 0;
        private int lineCount = 0;

        private BlockAndLineCounter() {
        }

        public void visit(SimulinkBlock element) {
            ++this.blockCount;
            this.lineCount += element.getOutLines().size();
        }
    }
}

