/*
 * Decompiled with CFR 0.152.
 */
package com.polarion.alm.ws.client;

public class Utils {
    private static final String DEFAULT_REPOSITORY_NAME = "default";
    private static final char REPO_DELIM = ':';
    private static final String REPO_DELIM_STR = ":";
    private static final char REVISION_DELIM = '#';
    private static final String REVISION_DELIM_STR = "#";

    private Utils() {
    }

    public static String encodeLocation(String repositoryName, String locationPath, String revision) {
        StringBuffer buf = new StringBuffer();
        if (repositoryName != null) {
            buf.append(Utils.escapeString(repositoryName));
            buf.append(':');
        }
        buf.append(Utils.escapeString(locationPath));
        if (revision != null) {
            buf.append('#');
            buf.append(Utils.escapeString(revision));
        }
        return buf.toString();
    }

    private static String escapeString(String s) {
        return s.replaceAll("\\\\", "\\\\\\\\").replaceAll(REPO_DELIM_STR, "\\\\:").replaceAll(REVISION_DELIM_STR, "\\\\#");
    }

    public static String encodeAbsoluteLocationWithDefaultRepository(String locationPath, String revision) {
        return Utils.encodeLocation(DEFAULT_REPOSITORY_NAME, locationPath, revision);
    }

    public static String encodeRelativeLocation(String locationPath, String revision) {
        return Utils.encodeLocation(null, locationPath, revision);
    }

    public static String[] decodeLocation(String encodedLocation) {
        String revision;
        String locPath;
        if (encodedLocation == null) {
            return null;
        }
        boolean escaped = false;
        String[] comps = new String[3];
        int index = 0;
        boolean hasRepo = false;
        boolean hasRev = false;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < encodedLocation.length(); ++i) {
            char c = encodedLocation.charAt(i);
            if (escaped) {
                buf.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ':' || c == '#') {
                if (c == ':') {
                    hasRepo = true;
                }
                if (c == '#') {
                    hasRev = true;
                }
                comps[index] = buf.toString();
                if (++index > 2) {
                    throw new IllegalArgumentException("Malformed encoded location: " + encodedLocation);
                }
                buf = new StringBuffer();
                continue;
            }
            buf.append(c);
        }
        comps[index] = buf.toString();
        String repoName = hasRepo ? comps[0] : null;
        String string = locPath = hasRepo ? comps[1] : comps[0];
        String string2 = hasRev ? (hasRepo ? comps[2] : comps[1]) : (revision = null);
        if (locPath == null) {
            locPath = "";
        }
        return new String[]{repoName, locPath, revision};
    }
}

