/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.registry;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.teamscale.commons.TextResourceLoader;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class CheckDescriptionLoader {
    private static final String CHECK_DESCRIPTION_DIRECTORY_NAME = "check-descriptions";
    private static final List<String> CHECK_DESCRIPTION_SUBDIRECTORIES_NAMES = List.of("", "sonarlint/");
    private static final LoadingCache<CheckDescriptionKey, Optional<String>> CHECK_DESCRIPTION_CACHE = Caffeine.newBuilder().maximumSize(2000L).build(CheckDescriptionLoader::loadCheckDescription);
    private static TextResourceLoader instance;

    private static TextResourceLoader getLoader() {
        if (instance == null) {
            instance = new TextResourceLoader(CHECK_DESCRIPTION_DIRECTORY_NAME);
        }
        return instance;
    }

    private static Optional<String> loadCheckDescription(CheckDescriptionKey key) {
        for (String directory : CHECK_DESCRIPTION_SUBDIRECTORIES_NAMES) {
            Optional textResource = CheckDescriptionLoader.getLoader().getTextResource(key.contextClass(), directory + key.descriptionPath());
            if (!textResource.isPresent()) continue;
            return textResource;
        }
        return Optional.empty();
    }

    public static Optional<String> getCheckDescription(Class<?> contextClass, String descriptionPath) {
        return (Optional)CHECK_DESCRIPTION_CACHE.get((Object)new CheckDescriptionKey(contextClass, descriptionPath));
    }

    public static Optional<Path> getDirectoryInCheckDescriptions(String descriptionPath) {
        return CheckDescriptionLoader.getLoader().getDirectoryInResourceFolder(descriptionPath);
    }

    private record CheckDescriptionKey(Class<?> contextClass, String descriptionPath) {
    }
}

