/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Objects;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public abstract class Token
implements IToken {
    private static final long serialVersionUID = 1L;
    protected final ETokenType type;
    protected final int offset;
    protected final int lineNumber;
    protected final String text;
    protected final String originId;

    protected Token(ETokenType type, long offset, int lineNumber, String text, String originId) {
        this.type = type;
        this.offset = (int)offset;
        this.lineNumber = lineNumber;
        this.text = text;
        this.originId = originId;
    }

    public String toString() {
        String result = "TOKEN (" + String.valueOf(this.type) + ") Text: >>" + this.text + "<<";
        result = result + " Origin: '" + this.originId + "' line#: " + this.lineNumber + " offset: " + this.offset;
        return result;
    }

    public String getText() {
        return this.text;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEndOffset() {
        return this.offset + this.text.length() - 1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getOriginId() {
        return this.originId;
    }

    public ETokenType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        return this.type == other.type && this.offset == other.offset && this.lineNumber == other.lineNumber && Objects.equals(this.text, other.text) && Objects.equals(this.originId, other.originId);
    }

    public final int hashCode() {
        return Objects.hash(this.type, this.offset, this.lineNumber, this.text, this.originId);
    }
}

