/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.util;

import eu.cqse.check.framework.shallowparser.ShallowParserException;
import org.conqat.lib.commons.string.StringUtils;

public class EntitySelectionExpressionParsingException
extends ShallowParserException {
    private static final long serialVersionUID = 1L;
    private final EParsingExceptionMessage messageIdentifier;

    public EntitySelectionExpressionParsingException(EParsingExceptionMessage messageIdentifier, String expression, int position) {
        super(EntitySelectionExpressionParsingException.createMessage(messageIdentifier, expression, position, null));
        this.messageIdentifier = messageIdentifier;
    }

    public EntitySelectionExpressionParsingException(EParsingExceptionMessage messageIdentifier, String expression, int position, Throwable cause) {
        super(EntitySelectionExpressionParsingException.createMessage(messageIdentifier, expression, position, cause), cause);
        this.messageIdentifier = messageIdentifier;
    }

    private static String createMessage(EParsingExceptionMessage messageIdentifier, String expression, int position, Throwable cause) {
        Object message = messageIdentifier.getMessage();
        if (cause != null) {
            message = (String)message + ": " + cause.getMessage();
        }
        if (!StringUtils.endsWithOneOf((String)message, (String[])new String[]{".", "!"})) {
            message = (String)message + ".";
        }
        String details = "The error occurred at or before the position marked with a caret: " + expression.substring(0, position) + "^" + expression.substring(position);
        return (String)message + " " + details;
    }

    public EParsingExceptionMessage getMessageIdentifier() {
        return this.messageIdentifier;
    }

    public static enum EParsingExceptionMessage {
        EXPECTED_EXPRESSION("Expected an expression before or at this position."),
        EXPECTED_BINARY_OPERATOR("Expected a binary operator such as & or |."),
        PREDICATE_CONSTRUCTION_FAILED("Failed to construct predicate"),
        PARAMETER_MISSING("Must provide parameter for this predicate!"),
        UNSUPPORTED_PARAMETER("May not provide parameter for this predicate!"),
        PREDICATE_NOT_FOUND("No matching predicate found!"),
        MISSING_CLOSING_PARENTHESIS("Missing closing parenthesis!"),
        MISPLACED_CLOSING_PARENTHESIS("Misplaced closing parenthesis."),
        UNEXPECTED_CHARACTER("Unexpected character.");

        private final String message;

        private EParsingExceptionMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

