/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.languages.abap.AbapShallowParser;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.ILanguageFeatureParser;
import eu.cqse.check.framework.util.abap.FunctionCallInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class AbapLanguageFeatureParser
implements ILanguageFeatureParser {
    private static final ITokenMatcher PARAMETER_SECTION_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.USING, ETokenType.CHANGING, ETokenType.IMPORTING, ETokenType.EXPORTING, ETokenType.RETURNING, ETokenType.TABLES, ETokenType.TESTING, ETokenType.RAISING});
    private static final Pattern KEYWORD_OR_OPERATOR_AS_IDENTIFIER_PATTERN = Pattern.compile("(?i)[A-Z][A-Z0-9_]*");

    AbapLanguageFeatureParser() {
    }

    @Override
    public ELanguage getLanguage() {
        return ELanguage.ABAP;
    }

    public Pair<String, Integer> getNextTypeName(List<IToken> tokens, int startIndex) {
        int typeKeywordIndex = TokenStreamUtils.firstTokenMatching(tokens, startIndex, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TYPE, ETokenType.LIKE, ETokenType.STRUCTURE}));
        if (typeKeywordIndex == -1) {
            return new Pair((Object)"", (Object)(startIndex - 1));
        }
        int endIndex = TokenStreamUtils.firstTokenMatching(tokens, typeKeywordIndex + 1, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TYPE, ETokenType.LIKE, ETokenType.STRUCTURE}));
        if (endIndex == -1) {
            endIndex = TokenStreamUtils.firstTokenMatching(tokens, typeKeywordIndex, (ITokenMatcher)ETokenType.DOT);
            if (endIndex == -1) {
                endIndex = tokens.size();
            }
        } else {
            endIndex = endIndex >= 3 && tokens.get(endIndex - 3).getType() == ETokenType.LPAREN && tokens.get(endIndex - 1).getType() == ETokenType.RPAREN ? (endIndex -= 4) : --endIndex;
        }
        if (endIndex > 2 && endIndex <= tokens.size()) {
            if (tokens.get(endIndex - 1).getType() == ETokenType.OPTIONAL) {
                --endIndex;
            } else if (tokens.get(endIndex - 2).getType() == ETokenType.DEFAULT) {
                endIndex -= 2;
            }
        }
        if (typeKeywordIndex < endIndex) {
            return new Pair((Object)TokenStreamTextUtils.concatTokenTexts(tokens.subList(typeKeywordIndex + 1, endIndex), " ").toLowerCase(), (Object)(endIndex - 1));
        }
        return new Pair((Object)"", (Object)Math.max(startIndex, endIndex));
    }

    public List<TypedVariable> getTypeInfoForMethodParameters(ShallowEntity entity, List<IToken> tokens) {
        if (TokenStreamUtils.startsWith(tokens, ETokenType.FOR, ETokenType.EVENT)) {
            return this.processMethodEventHandler(entity, tokens);
        }
        return this.processParameterList(entity, tokens);
    }

    private List<TypedVariable> processParameterList(ShallowEntity entity, List<IToken> tokens) {
        ArrayList<TypedVariable> typeInfo = new ArrayList<TypedVariable>();
        List<Integer> positionsOfSectionTokens = TokenStreamUtils.findAll(tokens, PARAMETER_SECTION_TOKENS);
        for (int i = 0; i < positionsOfSectionTokens.size(); ++i) {
            int positionOfCurrentSectionToken = positionsOfSectionTokens.get(i);
            IToken sectionName = tokens.get(positionOfCurrentSectionToken);
            int endOfSection = i < positionsOfSectionTokens.size() - 1 ? positionsOfSectionTokens.get(i + 1).intValue() : tokens.size();
            List<IToken> section = tokens.subList(positionOfCurrentSectionToken + 1, endOfSection);
            this.processHeaderSection(entity, typeInfo, section, sectionName);
        }
        return typeInfo;
    }

    private void processHeaderSection(ShallowEntity containingEntity, List<TypedVariable> typeInfo, List<IToken> section, IToken sectionName) {
        ArrayList<IToken> sectionModifiers = new ArrayList<IToken>();
        sectionModifiers.add(sectionName);
        int dotIndex = TokenStreamUtils.firstTokenMatching(section, (ITokenMatcher)ETokenType.DOT);
        if (dotIndex != -1) {
            section = section.subList(0, dotIndex);
        }
        int currentIndex = 0;
        while (currentIndex < section.size()) {
            String variableName;
            ArrayList<IToken> currentParameterModifiers = new ArrayList<IToken>(sectionModifiers);
            if (TokenStreamUtils.hasTokenTypeSequence(section, currentIndex + 1, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN)) {
                variableName = section.get(currentIndex + 2).getText();
                currentIndex += 4;
            } else {
                variableName = section.get(currentIndex).getText();
                ++currentIndex;
            }
            Pair<String, Integer> type = this.getNextTypeName(section, currentIndex);
            Pair<List<IToken>, Integer> afterTypeModifiers = AbapLanguageFeatureParser.getAfterTypeModifiers(section, (Integer)type.getSecond() + 1);
            currentParameterModifiers.addAll((Collection)afterTypeModifiers.getFirst());
            typeInfo.add(new TypedVariable(this.normalizeVariable(variableName), ((String)type.getFirst()).toLowerCase(), currentParameterModifiers, containingEntity));
            currentIndex = (Integer)afterTypeModifiers.getSecond() + 1;
        }
    }

    private static Pair<List<IToken>, Integer> getAfterTypeModifiers(List<IToken> tokens, Integer startIndex) {
        if (tokens.size() <= startIndex) {
            return new Pair(Collections.emptyList(), (Object)(startIndex - 1));
        }
        if (tokens.get(startIndex).getType() == ETokenType.OPTIONAL) {
            return new Pair(Collections.singletonList(tokens.get(startIndex)), (Object)startIndex);
        }
        if (tokens.get(startIndex).getType() == ETokenType.DEFAULT) {
            return new Pair(Collections.singletonList(tokens.get(startIndex)), (Object)(startIndex + 1));
        }
        return new Pair(Collections.emptyList(), (Object)(startIndex - 1));
    }

    private List<TypedVariable> processMethodEventHandler(ShallowEntity entity, List<IToken> tokens) throws AssertionError {
        int importingIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.IMPORTING);
        if (importingIndex == -1) {
            return CollectionUtils.emptyList();
        }
        List<IToken> parameterTokens = tokens.subList(importingIndex + 1, tokens.size());
        return CollectionUtils.filterAndMap(parameterTokens, token -> token.getType() != ETokenType.DOT, token -> new TypedVariable(this.normalizeVariable(token.getText()), "", (List<IToken>)CollectionUtils.emptyList(), entity));
    }

    public List<IToken> getDeclarationTokensForMethod(List<ShallowEntity> rootEntities, ShallowEntity methodEntity) {
        return Optional.ofNullable(this.getMethodDeclaration(rootEntities, methodEntity)).map(ShallowEntity::includedTokens).orElse(null);
    }

    public ShallowEntity getClassDeclaration(List<ShallowEntity> rootEntities, ShallowEntity classEntity) {
        if (classEntity == null || classEntity.getName() == null) {
            return null;
        }
        if (AbapLanguageFeatureParser.isClassOrInterfaceDefinition(classEntity)) {
            return classEntity;
        }
        ArrayList result = new ArrayList();
        ShallowEntity.traverse(rootEntities, entity -> AbapLanguageFeatureParser.visitToFindClassDeclaration(entity, classEntity.getName(), result));
        return (ShallowEntity)CollectionUtils.getAny(result);
    }

    private static boolean visitToFindClassDeclaration(ShallowEntity entity, String name, List<ShallowEntity> result) {
        if (AbapLanguageFeatureParser.isClassOrInterfaceDefinition(entity) && name.equals(entity.getName())) {
            result.add(entity);
        }
        return result.isEmpty() && entity.getType() != EShallowEntityType.METHOD && !AbapLanguageFeatureParser.isClassOrInterfaceDefinition(entity) && !entity.getSubtype().equals("class implementation");
    }

    private static boolean isClassOrInterfaceDefinition(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE && Set.of("class definition", "interface definition").contains(entity.getSubtype());
    }

    public ShallowEntity getMethodDeclaration(List<ShallowEntity> rootEntities, ShallowEntity methodImplementation) {
        ShallowEntity classDeclaration = null;
        if (methodImplementation.getParent() != null) {
            classDeclaration = this.getClassDeclaration(rootEntities, methodImplementation.getParent());
        }
        if (classDeclaration == null) {
            return null;
        }
        List methodEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)classDeclaration.getChildren(), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity methodEntity : methodEntities) {
            if (!methodEntity.getSubtype().equals("method declaration") || methodImplementation.getName() == null || !methodImplementation.getName().equals(methodEntity.getName())) continue;
            return methodEntity;
        }
        return null;
    }

    public Optional<FunctionCallInfo> getFunctionCallInfo(ShallowEntity callFunctionStatement) throws CheckException {
        if (callFunctionStatement.getType() != EShallowEntityType.STATEMENT) {
            return Optional.empty();
        }
        UnmodifiableList tokens = callFunctionStatement.ownStartTokens();
        if (tokens.size() < 3 || !TokenStreamUtils.startsWith((List<IToken>)tokens, ETokenType.CALL, ETokenType.FUNCTION)) {
            return Optional.empty();
        }
        return Optional.of(new FunctionCallInfo(AbapLanguageFeatureParser.filterIllegalCharacterTokens((List<IToken>)tokens)));
    }

    private static List<IToken> filterIllegalCharacterTokens(List<IToken> tokens) {
        return CollectionUtils.filter(tokens, token -> token.getType() != ETokenType.ILLEGAL_CHARACTER);
    }

    public String normalizeVariable(String name) {
        return StringUtils.stripPrefix((String)name, (String)"!").toLowerCase();
    }

    public boolean isPossiblyIdentifier(IToken token) {
        ETokenType tokenType = token.getType();
        if (tokenType.isIdentifier()) {
            return true;
        }
        if (tokenType.isKeyword() || tokenType.isOperator()) {
            return KEYWORD_OR_OPERATOR_AS_IDENTIFIER_PATTERN.matcher(token.getText()).matches();
        }
        return false;
    }

    public boolean isGenericExceptionClass(String className) {
        return Optional.ofNullable(className).map(s -> s.equalsIgnoreCase("cx_root")).orElse(false);
    }

    public boolean isProgramInclude(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.META && entity.getType() != EShallowEntityType.STATEMENT || !entity.getSubtype().equals("include")) {
            return false;
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        return tokens.size() >= 2 && !AbapShallowParser.INCLUDE_FILTER_TOKEN_TYPES.matches((IToken)tokens.get(1));
    }
}

