/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.markdown;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.channel.RegexChannel;
import org.sonar.markdown.MarkdownOutput;

class HtmlLinkChannel
extends RegexChannel<MarkdownOutput> {
    private static final String LINK_REGEX = "\\[([^\\]]+)\\]\\(([^\\)]+)\\)";
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[([^\\]]+)\\]\\(([^\\)]+)\\)");

    public HtmlLinkChannel() {
        super(LINK_REGEX);
    }

    @Override
    protected void consume(CharSequence token, MarkdownOutput output) {
        Matcher matcher = LINK_PATTERN.matcher(token);
        matcher.matches();
        String content = matcher.group(1);
        String url = matcher.group(2);
        output.append("<a href=\"");
        output.append(url);
        output.append("\" target=\"_blank\">");
        output.append(content);
        output.append("</a>");
    }
}

