/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.branch;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.backend.branch.DidChangeActiveSonarProjectBranchParams;
import org.sonarsource.sonarlint.core.clientapi.backend.branch.SonarProjectBranchService;
import org.sonarsource.sonarlint.core.event.ActiveSonarProjectBranchChanged;
import org.sonarsource.sonarlint.core.event.ConfigurationScopeRemovedEvent;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.vcs.ActiveSonarProjectBranchRepository;

@Named
@Singleton
public class SonarProjectBranchServiceImpl
implements SonarProjectBranchService {
    private final ActiveSonarProjectBranchRepository activeSonarProjectBranchRepository;
    private final ConfigurationRepository configurationRepository;
    private final EventBus eventBus;

    public SonarProjectBranchServiceImpl(ActiveSonarProjectBranchRepository activeSonarProjectBranchRepository, ConfigurationRepository configurationRepository, EventBus eventBus) {
        this.activeSonarProjectBranchRepository = activeSonarProjectBranchRepository;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
    }

    @Override
    public void didChangeActiveSonarProjectBranch(DidChangeActiveSonarProjectBranchParams params) {
        String configScopeId;
        String oldBranchName;
        String newActiveBranchName = params.getNewActiveBranchName();
        if (!newActiveBranchName.equals(oldBranchName = this.activeSonarProjectBranchRepository.setActiveBranchName(configScopeId = params.getConfigScopeId(), params.getNewActiveBranchName()))) {
            this.eventBus.post((Object)new ActiveSonarProjectBranchChanged(configScopeId, newActiveBranchName));
        }
    }

    public Optional<String> getEffectiveActiveSonarProjectBranch(String configurationScopeId) {
        ConfigurationScope configurationScope;
        String currentConfigScopeId = configurationScopeId;
        while ((configurationScope = this.configurationRepository.getConfigurationScope(currentConfigScopeId)) != null) {
            Optional<String> maybeBranch = this.activeSonarProjectBranchRepository.getActiveSonarProjectBranch(currentConfigScopeId);
            if (maybeBranch.isPresent()) {
                return maybeBranch;
            }
            currentConfigScopeId = configurationScope.getParentId();
            if (currentConfigScopeId != null) continue;
        }
        return Optional.empty();
    }

    @Subscribe
    public void onConfigurationScopeRemoved(ConfigurationScopeRemovedEvent removedEvent) {
        String currentConfigScopeId = removedEvent.getRemovedConfigurationScopeId();
        this.activeSonarProjectBranchRepository.clearActiveProjectBranch(currentConfigScopeId);
    }
}

