/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons.log;

import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import org.sonarsource.sonarlint.core.commons.log.FormattingTuple;
import org.sonarsource.sonarlint.core.commons.log.LogOutputDelegator;
import org.sonarsource.sonarlint.core.commons.log.MessageFormatter;

public class SonarLintLogger {
    private static final SonarLintLogger logger = new SonarLintLogger(new LogOutputDelegator());
    private final LogOutputDelegator logOutput;

    public static SonarLintLogger get() {
        return logger;
    }

    public static void setTarget(@Nullable ClientLogOutput output) {
        SonarLintLogger.logger.logOutput.setTarget(output);
    }

    SonarLintLogger(LogOutputDelegator logOutput) {
        this.logOutput = logOutput;
    }

    public void trace(String msg) {
        this.logOutput.log(msg, ClientLogOutput.Level.TRACE);
    }

    public void trace(String msg, @Nullable Object arg) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.TRACE, msg, new Object[]{arg});
    }

    public void trace(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.TRACE, msg, new Object[]{arg1, arg2});
    }

    public void trace(String msg, Object ... args) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.TRACE, msg, args);
    }

    public void debug(String msg) {
        this.logOutput.log(msg, ClientLogOutput.Level.DEBUG);
    }

    public void debug(String msg, @Nullable Object arg) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.DEBUG, msg, new Object[]{arg});
    }

    public void debug(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.DEBUG, msg, new Object[]{arg1, arg2});
    }

    public void debug(String msg, Object ... args) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.DEBUG, msg, args);
    }

    public void info(String msg) {
        this.logOutput.log(msg, ClientLogOutput.Level.INFO);
    }

    public void info(String msg, @Nullable Object arg) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.INFO, msg, new Object[]{arg});
    }

    public void info(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.INFO, msg, new Object[]{arg1, arg2});
    }

    public void info(String msg, Object ... args) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.INFO, msg, args);
    }

    public void warn(String msg) {
        this.logOutput.log(msg, ClientLogOutput.Level.WARN);
    }

    public void warn(String msg, Throwable thrown) {
        this.logOutput.log(msg, ClientLogOutput.Level.WARN, thrown);
    }

    public void warn(String msg, @Nullable Object arg) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.WARN, msg, new Object[]{arg});
    }

    public void warn(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.WARN, msg, new Object[]{arg1, arg2});
    }

    public void warn(String msg, Object ... args) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.WARN, msg, args);
    }

    public void error(String msg) {
        this.logOutput.log(msg, ClientLogOutput.Level.ERROR);
    }

    public void error(String msg, @Nullable Object arg) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.ERROR, msg, new Object[]{arg});
    }

    public void error(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.ERROR, msg, new Object[]{arg1, arg2});
    }

    public void error(String msg, Object ... args) {
        this.doLogExtractingThrowable(ClientLogOutput.Level.ERROR, msg, args);
    }

    public void error(String msg, Throwable thrown) {
        this.logOutput.log(msg, ClientLogOutput.Level.ERROR, thrown);
    }

    private void doLogExtractingThrowable(ClientLogOutput.Level level, String msg, Object[] argArray) {
        FormattingTuple tuple = MessageFormatter.arrayFormat(msg, argArray);
        this.logOutput.log(tuple.getMessage(), level, tuple.getThrowable());
    }

    public static String singlePlural(int count, String singular, String plural) {
        return count == 1 ? singular : plural;
    }
}

