/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rule.extractor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.commons.VulnerabilityProbability;

@Immutable
public final class SecurityStandards {
    public static final String UNKNOWN_STANDARD = "unknown";
    private static final String CWE_PREFIX = "cwe:";
    public static final Map<SLCategory, Set<String>> CWES_BY_SL_CATEGORY = Map.ofEntries(Map.entry(SLCategory.BUFFER_OVERFLOW, Set.of("119", "120", "131", "676", "788")), Map.entry(SLCategory.SQL_INJECTION, Set.of("89", "564", "943")), Map.entry(SLCategory.COMMAND_INJECTION, Set.of("77", "78", "88", "214")), Map.entry(SLCategory.PATH_TRAVERSAL_INJECTION, Set.of("22")), Map.entry(SLCategory.LDAP_INJECTION, Set.of("90")), Map.entry(SLCategory.XPATH_INJECTION, Set.of("643")), Map.entry(SLCategory.RCE, Set.of("94", "95")), Map.entry(SLCategory.DOS, Set.of("400", "624")), Map.entry(SLCategory.SSRF, Set.of("918")), Map.entry(SLCategory.CSRF, Set.of("352")), Map.entry(SLCategory.XSS, Set.of("79", "80", "81", "82", "83", "84", "85", "86", "87")), Map.entry(SLCategory.LOG_INJECTION, Set.of("117")), Map.entry(SLCategory.HTTP_RESPONSE_SPLITTING, Set.of("113")), Map.entry(SLCategory.OPEN_REDIRECT, Set.of("601")), Map.entry(SLCategory.XXE, Set.of("611", "827")), Map.entry(SLCategory.OBJECT_INJECTION, Set.of("134", "470", "502")), Map.entry(SLCategory.WEAK_CRYPTOGRAPHY, Set.of("295", "297", "321", "322", "323", "324", "325", "326", "327", "328", "330", "780")), Map.entry(SLCategory.AUTH, Set.of("798", "640", "620", "549", "522", "521", "263", "262", "261", "259", "308")), Map.entry(SLCategory.INSECURE_CONF, Set.of("102", "215", "346", "614", "489", "942")), Map.entry(SLCategory.FILE_MANIPULATION, Set.of("97", "73")), Map.entry(SLCategory.ENCRYPTION_OF_SENSITIVE_DATA, Set.of("311", "315", "319")), Map.entry(SLCategory.TRACEABILITY, Set.of("778")), Map.entry(SLCategory.PERMISSION, Set.of("266", "269", "284", "668", "732")));
    private final Set<String> standards;
    private final Set<String> cwe;
    private final SLCategory sLCategory;
    private final Set<SLCategory> ignoredSLCategories;

    private SecurityStandards(Set<String> standards, Set<String> cwe, SLCategory sLCategory, Set<SLCategory> ignoredSLCategories) {
        this.standards = standards;
        this.cwe = cwe;
        this.sLCategory = sLCategory;
        this.ignoredSLCategories = ignoredSLCategories;
    }

    public SLCategory getSlCategory() {
        return this.sLCategory;
    }

    public Set<SLCategory> getIgnoredSLCategories() {
        return this.ignoredSLCategories;
    }

    public Set<String> getStandards() {
        return this.standards;
    }

    public Set<String> getCwe() {
        return this.cwe;
    }

    public static SecurityStandards fromSecurityStandards(Set<String> securityStandards) {
        Set<String> standards = securityStandards.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        Set<String> cwe = SecurityStandards.toCwes(standards);
        List<SLCategory> sl = SecurityStandards.toSLCategories(cwe);
        SLCategory slCategory = sl.iterator().next();
        Set<SLCategory> ignoredSLCategories = sl.stream().skip(1L).collect(Collectors.toSet());
        return new SecurityStandards(standards, cwe, slCategory, ignoredSLCategories);
    }

    private static Set<String> toCwes(Collection<String> securityStandards) {
        Set result = securityStandards.stream().filter(s -> s.startsWith(CWE_PREFIX)).map(s -> s.substring(CWE_PREFIX.length())).collect(Collectors.toSet());
        return result.isEmpty() ? Collections.singleton(UNKNOWN_STANDARD) : result;
    }

    private static List<SLCategory> toSLCategories(Collection<String> cwe) {
        List result = CWES_BY_SL_CATEGORY.keySet().stream().filter(k -> cwe.stream().anyMatch(CWES_BY_SL_CATEGORY.get(k)::contains)).collect(Collectors.toList());
        return result.isEmpty() ? Collections.singletonList(SLCategory.OTHERS) : result;
    }

    public static enum SLCategory {
        BUFFER_OVERFLOW("buffer-overflow", VulnerabilityProbability.HIGH),
        SQL_INJECTION("sql-injection", VulnerabilityProbability.HIGH),
        RCE("rce", VulnerabilityProbability.MEDIUM),
        OBJECT_INJECTION("object-injection", VulnerabilityProbability.LOW),
        COMMAND_INJECTION("command-injection", VulnerabilityProbability.HIGH),
        PATH_TRAVERSAL_INJECTION("path-traversal-injection", VulnerabilityProbability.HIGH),
        LDAP_INJECTION("ldap-injection", VulnerabilityProbability.LOW),
        XPATH_INJECTION("xpath-injection", VulnerabilityProbability.LOW),
        LOG_INJECTION("log-injection", VulnerabilityProbability.LOW),
        XXE("xxe", VulnerabilityProbability.MEDIUM),
        XSS("xss", VulnerabilityProbability.HIGH),
        DOS("dos", VulnerabilityProbability.MEDIUM),
        SSRF("ssrf", VulnerabilityProbability.MEDIUM),
        CSRF("csrf", VulnerabilityProbability.HIGH),
        HTTP_RESPONSE_SPLITTING("http-response-splitting", VulnerabilityProbability.LOW),
        OPEN_REDIRECT("open-redirect", VulnerabilityProbability.MEDIUM),
        WEAK_CRYPTOGRAPHY("weak-cryptography", VulnerabilityProbability.MEDIUM),
        AUTH("auth", VulnerabilityProbability.HIGH),
        INSECURE_CONF("insecure-conf", VulnerabilityProbability.LOW),
        FILE_MANIPULATION("file-manipulation", VulnerabilityProbability.LOW),
        ENCRYPTION_OF_SENSITIVE_DATA("encrypt-data", VulnerabilityProbability.LOW),
        TRACEABILITY("traceability", VulnerabilityProbability.LOW),
        PERMISSION("permission", VulnerabilityProbability.MEDIUM),
        OTHERS("others", VulnerabilityProbability.LOW);

        private final String key;
        private final VulnerabilityProbability vulnerability;

        private SLCategory(String key, VulnerabilityProbability vulnerability) {
            this.key = key;
            this.vulnerability = vulnerability;
        }

        public String getKey() {
            return this.key;
        }

        public VulnerabilityProbability getVulnerability() {
            return this.vulnerability;
        }
    }
}

