/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j.backend;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.cache4j.backend.ICacheBackend;

class SoftRefCacheBackend<K, V>
implements ICacheBackend<K, V> {
    private static final int CLEANUP_INTERVAL = 1000;
    private int storeCalls = 0;
    private final Map<K, SoftReference<V>> cache = new HashMap<K, SoftReference<V>>();

    SoftRefCacheBackend() {
    }

    @Override
    public void store(K key, V value) {
        this.cache.put(key, new SoftReference<V>(value));
        ++this.storeCalls;
        if (this.storeCalls >= Math.max(1000, this.cache.size())) {
            this.storeCalls = 0;
            this.cleanUp();
        }
    }

    private void cleanUp() {
        ArrayList<K> staleKeys = new ArrayList<K>();
        for (Map.Entry<K, SoftReference<V>> entry : this.cache.entrySet()) {
            if (entry.getValue() != null && entry.getValue().get() != null) continue;
            staleKeys.add(entry.getKey());
        }
        for (Map.Entry<K, SoftReference<V>> key : staleKeys) {
            this.cache.remove(key);
        }
    }

    @Override
    public V retrieve(K key) {
        SoftReference<V> softReference = this.cache.get(key);
        if (softReference == null) {
            return null;
        }
        return softReference.get();
    }

    @Override
    public SoftRefCacheBackend<K, V> newInstance() {
        return new SoftRefCacheBackend<K, V>();
    }
}

