/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.io.Serializable;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableMapImpl;
import org.conqat.lib.commons.collections.UnmodifiableSequencedMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public sealed interface UnmodifiableMap<K, V>
extends Map<K, V>,
Serializable
permits UnmodifiableSequencedMap, UnmodifiableMapImpl {
    public static <K, V> UnmodifiableMap<K, V> of(Map<K, V> map) {
        if (map instanceof UnmodifiableMap) {
            UnmodifiableMap unmodifiable = (UnmodifiableMap)map;
            return unmodifiable;
        }
        return new UnmodifiableMapImpl<K, V>(map);
    }

    @Override
    public @NonNull UnmodifiableSet<K> keySet();

    @Override
    public @NonNull UnmodifiableCollection<V> values();

    @Override
    public @NonNull UnmodifiableSet<Map.Entry<K, V>> entrySet();

    @Override
    @Deprecated
    default public @Nullable V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void putAll(@NonNull Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public @Nullable V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public @Nullable V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V computeIfAbsent(K key, @NonNull Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V computeIfPresent(K key, @NonNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V compute(K key, @NonNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V merge(K key, @NonNull V value, @NonNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }
}

