/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.collections.EDurableCollectionOperation;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.io.ByteArrayUtils;

abstract class DurableCollectionHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte[] EMPTY = new byte[0];
    private static final int MIN_DELTAS = 16;
    private final IStore store;
    private final byte[] keyPrefix;
    private int operationCount = 0;
    private long generationId = 0L;

    protected DurableCollectionHelper(IStore store, byte[] keyPrefix) throws StorageException {
        this.store = store;
        this.keyPrefix = keyPrefix;
        List<byte[]> values = DurableCollectionHelper.loadValues(store, keyPrefix);
        if (values.isEmpty()) {
            this.storeSnapshot();
        } else if (values.get(0) == null) {
            LOGGER.error("Snapshot entry is missing, but operation entries found. Looks like the database is corrupt.");
            store.removeByPrefix(keyPrefix);
            this.operationCount = 0;
            this.generationId = 0L;
        } else {
            this.generationId = DurableCollectionHelper.extractGenerationId(values.get(0));
            this.replayOperation(EDurableCollectionOperation.SNAPSHOT, DurableCollectionHelper.extractParameter(values.get(0)));
            while (this.operationCount < values.size() - 1) {
                byte[] value = values.get(this.operationCount + 1);
                if (value == null || DurableCollectionHelper.extractGenerationId(value) != this.generationId) {
                    return;
                }
                ++this.operationCount;
                this.replayOperation(EDurableCollectionOperation.values()[value[8]], DurableCollectionHelper.extractParameter(value));
            }
        }
    }

    private static List<byte[]> loadValues(IStore store, byte[] keyPrefix) throws StorageException {
        int expectedKeySize = keyPrefix.length + 4;
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        store.scan(keyPrefix, (key, value) -> {
            if (key.length != expectedKeySize) {
                return;
            }
            int operationIndex = ByteArrayUtils.byteArrayToInt((byte[])Arrays.copyOfRange(key, key.length - 4, key.length));
            List list = values;
            synchronized (list) {
                while (values.size() <= operationIndex) {
                    values.add(null);
                }
                values.set(operationIndex, value);
            }
        });
        return values;
    }

    private static byte[] extractParameter(byte[] value) {
        return Arrays.copyOfRange(value, 9, value.length);
    }

    private static long extractGenerationId(byte[] value) {
        return ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOf(value, 8));
    }

    public void storeOperation(EDurableCollectionOperation operation, byte[] parameter) throws StorageException {
        ++this.operationCount;
        if (this.recordDelta()) {
            if (parameter == null) {
                parameter = EMPTY;
            }
            byte[] value = ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.longToByteArray((long)this.generationId), {(byte)operation.ordinal()}, parameter});
            this.store.put(this.makeKey(), value);
        } else {
            this.storeSnapshot();
        }
    }

    private void storeSnapshot() throws StorageException {
        this.operationCount = 0;
        ++this.generationId;
        byte[] value = ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.longToByteArray((long)this.generationId), {(byte)EDurableCollectionOperation.SNAPSHOT.ordinal()}, this.serializeFullCollection()});
        this.store.put(this.makeKey(), value);
    }

    private boolean recordDelta() {
        return this.operationCount < 16 || this.operationCount < 2 * this.getCollectionSize();
    }

    private byte[] makeKey() {
        return ByteArrayUtils.concat((byte[][])new byte[][]{this.keyPrefix, ByteArrayUtils.intToByteArray((int)this.operationCount)});
    }

    protected abstract int getCollectionSize();

    protected abstract byte[] serializeFullCollection() throws StorageException;

    protected abstract void replayOperation(EDurableCollectionOperation var1, byte[] var2) throws StorageException;
}

