/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.TimedShallowObjectState;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class KeyedObjectIndexBase<T>
extends IndexBase
implements IKeyedObjectIndex<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final long MAX_TIMESTAMP = 0x7FFFFFFFFFFFFFFEL;
    protected static final byte[] SEPARATOR = new byte[]{1};
    private static final byte[] IS_NOT_SET = new byte[]{2};
    private static final byte[] IS_SET = new byte[]{3};
    protected static final byte[] OBJECT_PREFIX = new byte[]{2};
    protected static final byte[] COLUMN_PREFIX = new byte[]{3};
    private static final byte[] VALUE_PREFIX = new byte[]{4};
    private static final byte[] META_KEY_TYPE_PREFIX = new byte[]{5};
    private static final byte[] META_VALUE_PREFIX = new byte[]{6};
    protected static final byte[] REMOVED_VALUE = new byte[]{0};
    public static final String VALUE_SEPARATOR = ",";
    private final IKeyedObjectDescriber<T> describer;

    protected KeyedObjectIndexBase(IStore store, IKeyedObjectDescriber<T> describer) {
        super(store, false);
        this.describer = describer;
    }

    @Override
    public IKeyedObjectDescriber<T> getDescriber() {
        return this.describer;
    }

    @Override
    public List<TimedShallowObjectState> query(List<String> valueColumns, PairList<String, String> exactValueColumns) throws StorageException {
        return this.query(valueColumns, exactValueColumns, 0x7FFFFFFFFFFFFFFEL);
    }

    @Override
    public List<TimedShallowObjectState> query(List<String> valueColumns, PairList<String, String> exactValueColumns, long timestamp) throws StorageException {
        int size = valueColumns.size() + exactValueColumns.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        HashMap<String, TimedShallowObjectState> result = new HashMap<String, TimedShallowObjectState>();
        this.queryKeyColumns(valueColumns, timestamp, size, result);
        this.queryExactValueColumns(exactValueColumns, timestamp, size, valueColumns.size(), result);
        return new ArrayList<TimedShallowObjectState>(result.values());
    }

    private void queryKeyColumns(List<String> valueColumns, long timestamp, int size, Map<String, TimedShallowObjectState> result) throws StorageException {
        for (int i = 0; i < valueColumns.size(); ++i) {
            String key = valueColumns.get(i);
            byte[] beginKey = this.createColumnKey(key, 0L, "");
            byte[] endKey = this.createColumnKey(key, KeyedObjectIndexBase.incrementTimestamp(timestamp), "");
            int prefixLength = ByteArrayUtils.concat((byte[][])new byte[][]{COLUMN_PREFIX, StringUtils.stringToBytes((String)key), SEPARATOR}).length;
            StateCompletingCallback callback = new StateCompletingCallback(result, i, size, prefixLength);
            this.store.scan(beginKey, endKey, callback);
            callback.throwCaughtException();
        }
    }

    protected static long incrementTimestamp(long timestamp) {
        if (timestamp > 0x7FFFFFFFFFFFFFFEL) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        return timestamp + 1L;
    }

    private void queryExactValueColumns(PairList<String, String> exactValueColumns, long timestamp, int size, int offset, Map<String, TimedShallowObjectState> result) throws StorageException {
        for (int i = 0; i < exactValueColumns.size(); ++i) {
            String key = (String)exactValueColumns.getFirst(i);
            String value = (String)exactValueColumns.getSecond(i);
            byte[] beginKey = this.createValueKey(key, value, 0L, false, "");
            byte[] endKey = this.createValueKey(key, value, KeyedObjectIndexBase.incrementTimestamp(timestamp), false, "");
            ArrayList<byte[]> keys = new ArrayList<byte[]>();
            KeyCollectingCallback callback = new KeyCollectingCallback(keys);
            this.store.scanKeys(beginKey, endKey, callback);
            int prefixLength = ByteArrayUtils.concat((byte[][])new byte[][]{VALUE_PREFIX, StringUtils.stringToBytes((String)key), SEPARATOR, StringUtils.stringToBytes((String)value), SEPARATOR}).length;
            List splitKeys = CollectionUtils.mapWithException(keys, k -> this.getSplitValueKey(prefixLength, (byte[])k));
            splitKeys.sort(Comparator.comparingLong(x -> x.timestamp));
            for (SplitValueKey splitKey : splitKeys) {
                TimedShallowObjectState state = result.computeIfAbsent(splitKey.id, id -> new TimedShallowObjectState((String)id, size));
                String insertedValue = null;
                if (splitKey.isSet) {
                    insertedValue = value;
                }
                state.insert(offset + i, splitKey.timestamp, insertedValue);
            }
        }
    }

    private @NonNull SplitValueKey getSplitValueKey(int prefixLength, byte[] key) throws StorageException {
        byte[] parts = Arrays.copyOfRange(key, prefixLength, key.length);
        long timestamp = ByteArrayUtils.getLongFromByteArray((byte[])parts, (int)0);
        boolean isSet = parts[8] == IS_SET[0];
        String id = this.convertBytesToId(Arrays.copyOfRange(parts, 9, parts.length));
        return new SplitValueKey(timestamp, isSet, id);
    }

    @Override
    public PairList<String, EKeyedObjectType> getKnownColumns() throws StorageException {
        PairList result = new PairList();
        this.store.scan(META_KEY_TYPE_PREFIX, (key, value) -> {
            String name = StringUtils.bytesToString((byte[])Arrays.copyOfRange(key, 1, key.length));
            PairList pairList = result;
            synchronized (pairList) {
                result.add((Object)name, (Object)EKeyedObjectType.fromBinaryRepresentation(value));
            }
        });
        return result;
    }

    @Override
    public EKeyedObjectType getColumnType(String columnName) throws StorageException {
        PairList<String, EKeyedObjectType> columns = this.getKnownColumns();
        return IKeyedObjectIndex.getColumnType(columnName, columns);
    }

    @Override
    public List<String> getKnownValues(String key) throws StorageException {
        ArrayList<String> values = new ArrayList<String>();
        byte[] prefix = ByteArrayUtils.concat((byte[][])new byte[][]{META_VALUE_PREFIX, StringUtils.stringToBytes((String)key), SEPARATOR});
        this.store.scanKeys(prefix, (resultKey, value) -> {
            List list = values;
            synchronized (list) {
                values.add(StringUtils.bytesToString((byte[])Arrays.copyOfRange(resultKey, prefix.length, resultKey.length)));
            }
        });
        return values;
    }

    protected void removeIds(long timestamp, List<String> ids, ObjectUpdateHelper objectUpdateHelper) throws StorageException {
        for (String id : ids) {
            objectUpdateHelper.storeObject(id, timestamp, REMOVED_VALUE);
            Object oldObject = objectUpdateHelper.getOldObject(null, timestamp, id);
            if (oldObject == null) {
                LOGGER.warn("Trying to remove a keyed object that was never added: " + id);
                continue;
            }
            for (String key : this.describer.getKeys(oldObject)) {
                String oldValue = objectUpdateHelper.getValue(oldObject, key);
                objectUpdateHelper.deregisterValue(id, key, oldValue, timestamp);
                objectUpdateHelper.removeKeyValue(id, key, timestamp);
            }
        }
        this.store.put(objectUpdateHelper.getKeysValues());
    }

    protected void storeObject(T object, long timestamp, ObjectUpdateHelper objectUpdateHelper) throws StorageException {
        String oldValue;
        String id = this.describer.getId(object);
        objectUpdateHelper.storeObject(id, timestamp, this.describer.serialize(object));
        Object oldObject = objectUpdateHelper.getOldObject(object, timestamp, id);
        List<String> updatedKeys = this.describer.getKeys(object);
        for (String key : updatedKeys) {
            objectUpdateHelper.addKey(key);
            String value = objectUpdateHelper.getValue(object, key);
            objectUpdateHelper.getAllValues().add(new ByteArrayWrapper(KeyedObjectIndexBase.createMetaValueKey(key, value)));
            if (oldObject != null) {
                oldValue = objectUpdateHelper.getValue(oldObject, key);
                if (value.equalsIgnoreCase(oldValue)) continue;
                objectUpdateHelper.deregisterValue(id, key, oldValue, timestamp);
                objectUpdateHelper.insertNewKeyValue(id, key, value, timestamp);
                continue;
            }
            objectUpdateHelper.insertNewKeyValue(id, key, value, timestamp);
        }
        if (oldObject != null) {
            HashSet removedKeys = CollectionUtils.differenceSet(this.describer.getKeys(oldObject), (Collection[])new Collection[]{updatedKeys});
            for (String removedKey : removedKeys) {
                oldValue = objectUpdateHelper.getValue(oldObject, removedKey);
                objectUpdateHelper.deregisterValue(id, removedKey, oldValue, timestamp);
                objectUpdateHelper.removeKeyValue(id, removedKey, timestamp);
            }
        }
    }

    protected void storeMetaInformation(Set<String> allKeys, Set<ByteArrayWrapper> allValues) throws StorageException {
        PairList keysValues = new PairList();
        for (String key : allKeys) {
            keysValues.add((Object)KeyedObjectIndexBase.createMetaKeyTypeKey(key), (Object)this.describer.getType(key).getBinaryRepresentation());
        }
        for (ByteArrayWrapper value : allValues) {
            keysValues.add((Object)value.getBytes(), (Object)SEPARATOR);
        }
        this.store.put((PairList<byte[], byte[]>)keysValues);
    }

    protected byte[] createColumnKey(String key, long timestamp, String id) throws StorageException {
        return ByteArrayUtils.concat((byte[][])new byte[][]{COLUMN_PREFIX, StringUtils.stringToBytes((String)key), SEPARATOR, ByteArrayUtils.longToByteArray((long)timestamp), SEPARATOR, this.convertIdToBytes(id)});
    }

    private byte[] createValueKey(String key, byte[] value, long timestamp, boolean isSet, String id) throws StorageException {
        byte[] isSetValue = IS_NOT_SET;
        if (isSet) {
            isSetValue = IS_SET;
        }
        return ByteArrayUtils.concat((byte[][])new byte[][]{VALUE_PREFIX, StringUtils.stringToBytes((String)key), SEPARATOR, value, SEPARATOR, ByteArrayUtils.longToByteArray((long)timestamp), isSetValue, this.convertIdToBytes(id)});
    }

    private byte[] createValueKey(String key, String value, long timestamp, boolean isSet, String id) throws StorageException {
        return this.createValueKey(key, StringUtils.stringToBytes((String)value.toLowerCase()), timestamp, isSet, id);
    }

    private static byte[] createMetaKeyTypeKey(String key) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{META_KEY_TYPE_PREFIX, StringUtils.stringToBytes((String)key)});
    }

    private static byte[] createMetaValueKey(String key, String value) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{META_VALUE_PREFIX, StringUtils.stringToBytes((String)key), SEPARATOR, StringUtils.stringToBytes((String)value)});
    }

    protected @Nullable T deserialize(byte[] value) throws StorageException {
        if (KeyedObjectIndexBase.isEmptyValue(value)) {
            return null;
        }
        return this.describer.deserialize(value);
    }

    protected static boolean isEmptyValue(byte[] value) {
        return value == null || Arrays.equals(value, REMOVED_VALUE);
    }

    protected byte[] convertIdToBytes(String id) throws StorageException {
        return StringUtils.stringToBytes((String)id);
    }

    protected String convertBytesToId(byte[] id) throws StorageException {
        return StringUtils.bytesToString((byte[])id);
    }

    @ThreadSafe
    private class StateCompletingCallback
    extends ExceptionHandlingKeyValueCallbackBase {
        private final Map<String, TimedShallowObjectState> result;
        private final int keyIndex;
        private final int keySize;
        private final int prefixLength;

        private StateCompletingCallback(Map<String, TimedShallowObjectState> result, int keyIndex, int keySize, int prefixLength) {
            this.result = result;
            this.keyIndex = keyIndex;
            this.keySize = keySize;
            this.prefixLength = prefixLength;
        }

        @Override
        protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
            long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOfRange(key, this.prefixLength, this.prefixLength + 8));
            String id = KeyedObjectIndexBase.this.convertBytesToId(Arrays.copyOfRange(key, this.prefixLength + 8 + 1, key.length));
            if (Arrays.equals(value, REMOVED_VALUE)) {
                value = null;
            }
            TimedShallowObjectState state = this.result.computeIfAbsent(id, x -> new TimedShallowObjectState((String)x, this.keySize));
            state.insert(this.keyIndex, timestamp, StringUtils.bytesToString((byte[])value));
        }
    }

    private record SplitValueKey(long timestamp, boolean isSet, String id) {
    }

    protected abstract class ObjectUpdateHelper
    extends UpdateHelper {
        private final Map<String, Function<T, String>> accessors = new HashMap();
        private final Set<ByteArrayWrapper> allValues = new HashSet<ByteArrayWrapper>();
        protected final Map<String, T> oldObjectCache = new HashMap();
        protected final IKeyedObjectDescriber<T> describer;

        protected ObjectUpdateHelper(KeyedObjectIndexBase this$0, IKeyedObjectDescriber<T> describer) {
            this.describer = describer;
        }

        public abstract void storeObject(String var1, long var2, byte[] var4) throws StorageException;

        protected abstract T getOldObject(T var1, long var2, String var4) throws StorageException;

        private @NonNull String getValue(T object, String key) {
            String value = (String)this.accessors.computeIfAbsent(key, this.describer::getValueAccessor).apply(object);
            if (value == null) {
                value = "";
            }
            return value;
        }

        public Set<ByteArrayWrapper> getAllValues() {
            return this.allValues;
        }
    }

    public class UpdateHelper {
        private final Set<String> allKeys = new HashSet<String>();
        protected final PairList<byte[], byte[]> keysValues = new PairList();

        public void deregisterValue(String id, String key, String oldValue, long timestamp) throws StorageException {
            this.keysValues.add((Object)KeyedObjectIndexBase.this.createValueKey(key, oldValue, timestamp, false, id), (Object)SEPARATOR);
        }

        public void insertNewKeyValue(String id, String key, String value, long timestamp) throws StorageException {
            this.keysValues.add((Object)KeyedObjectIndexBase.this.createValueKey(key, value, timestamp, true, id), (Object)SEPARATOR);
            this.keysValues.add((Object)KeyedObjectIndexBase.this.createColumnKey(key, timestamp, id), (Object)StringUtils.stringToBytes((String)value));
        }

        public void removeKeyValue(String id, String key, long timestamp) throws StorageException {
            this.keysValues.add((Object)KeyedObjectIndexBase.this.createColumnKey(key, timestamp, id), (Object)REMOVED_VALUE);
        }

        public void addKey(String key) {
            this.allKeys.add(key);
        }

        public Set<String> getAllKeys() {
            return this.allKeys;
        }

        public PairList<byte[], byte[]> getKeysValues() {
            return this.keysValues;
        }
    }
}

