/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.parser;

import java.time.Duration;
import java.time.LocalDate;
import java.time.Year;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.IQueryPreprocessor;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryLexer;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.conqat.engine.persistence.index.keyed.query.parser.PartialParsingResult;
import org.conqat.engine.persistence.index.keyed.query.parser.PartialQueryExpression;
import org.conqat.engine.persistence.index.keyed.query.parser.PartialQueryExpressionParser;
import org.conqat.engine.persistence.index.keyed.query.tree.AndQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.AttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.ComparisonQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.EqualsQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.FalseQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.HasParentQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.IQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.InStateQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.InSubQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.LikeQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.NoOpQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.NotQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.OrQuery;
import org.conqat.engine.persistence.index.keyed.query.tree.StaticOperand;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;

public class QueryParser {
    private static final String START_OF_MONTH_LITERAL = "@startOfMonth";
    public static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, Year.now().getValue() - 50).appendPattern("-M-d").toFormatter();

    public static IQuery parse(String query) throws QueryParsingException, StorageException {
        return QueryParser.parse(query, Collections.emptyList());
    }

    public static IQuery parse(String query, Collection<IQueryPreprocessor> preprocessors) throws QueryParsingException, StorageException {
        CCSMAssert.isNotNull(preprocessors, (String)"Preprocessor may not be null!");
        List<QueryToken> tokens = QueryLexer.tokenize(query);
        for (IQueryPreprocessor preprocessor : preprocessors) {
            tokens = preprocessor.preprocessQuery(tokens);
        }
        return QueryParser.createQuery(tokens);
    }

    private static IQuery createQuery(List<QueryToken> tokens) throws QueryParsingException {
        if (tokens.isEmpty()) {
            return new NoOpQuery();
        }
        return QueryParser.createOrQuery(tokens);
    }

    private static IQuery createOrQuery(List<QueryToken> tokens) throws QueryParsingException {
        PartialParsingResult result = QueryParser.createAndQuery(tokens);
        List<QueryToken> remainingTokens = result.getRemainingTokens();
        if (remainingTokens.isEmpty()) {
            return result.getQuery();
        }
        QueryToken token = remainingTokens.get(0);
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.OR, token);
        return new OrQuery(result.getQuery(), QueryParser.createOrQuery(QueryParser.expectNonEmpty(CollectionUtils.getRest(remainingTokens), "||")));
    }

    private static PartialParsingResult createAndQuery(List<QueryToken> tokens) throws QueryParsingException {
        PartialParsingResult result = QueryParser.createNotQuery(tokens);
        List<QueryToken> remainingTokens = result.getRemainingTokens();
        if (remainingTokens.isEmpty() || remainingTokens.get(0).getType() != EQueryTokenType.AND) {
            return result;
        }
        PartialParsingResult tailResult = QueryParser.createAndQuery(QueryParser.expectNonEmpty(CollectionUtils.getRest(remainingTokens), "&&"));
        return new PartialParsingResult(new AndQuery(result.getQuery(), tailResult.getQuery()), tailResult.getRemainingTokens());
    }

    private static PartialParsingResult createNotQuery(List<QueryToken> tokens) throws QueryParsingException {
        if (!tokens.isEmpty() && tokens.get(0).getType() == EQueryTokenType.NOT) {
            PartialParsingResult expression = QueryParser.createExpression(CollectionUtils.getRest(tokens));
            return new PartialParsingResult(new NotQuery(expression.getQuery()), expression.getRemainingTokens());
        }
        return QueryParser.createExpression(tokens);
    }

    private static PartialParsingResult createExpression(List<QueryToken> tokens) throws QueryParsingException {
        EQueryTokenType firstTokenType = tokens.get(0).getType();
        if (firstTokenType == EQueryTokenType.PAREN_OPEN) {
            return QueryParser.createParenthesizedQuery(tokens);
        }
        if (firstTokenType == EQueryTokenType.IN_STATE) {
            return QueryParser.createInStateQuery(tokens);
        }
        if (firstTokenType == EQueryTokenType.HAS_PARENT) {
            return QueryParser.createHasParentQuery(tokens);
        }
        PartialQueryExpressionParser.expectNumberOfTokens(tokens, 3);
        PartialQueryExpression leftAttributeAndRemainingTokens = PartialQueryExpressionParser.parseLeftSideOfExpression(tokens);
        List<QueryToken> remainingTokens = leftAttributeAndRemainingTokens.getRemainingTokens();
        PartialQueryExpressionParser.expectNumberOfTokens(remainingTokens, 1);
        EQueryTokenType secondTokenType = remainingTokens.get(0).getType();
        if (secondTokenType == EQueryTokenType.NOT) {
            return QueryParser.createReorderedNotQuery(tokens, remainingTokens);
        }
        if (EQueryTokenType.isInOperator(secondTokenType)) {
            PartialQueryExpressionParser.expectNumberOfTokens(remainingTokens, 2);
            EQueryTokenType next = remainingTokens.get(1).getType();
            if (next == EQueryTokenType.QUERY) {
                return QueryParser.createInSubQueryExpression(leftAttributeAndRemainingTokens);
            }
            return QueryParser.createListExpression(leftAttributeAndRemainingTokens, secondTokenType == EQueryTokenType.LIKE_IN);
        }
        return QueryParser.createBasicExpression(leftAttributeAndRemainingTokens);
    }

    private static PartialParsingResult createInSubQueryExpression(PartialQueryExpression leftAttributeAndRemainingTokens) throws QueryParsingException {
        List<QueryToken> remaining = leftAttributeAndRemainingTokens.getRemainingTokens();
        PartialQueryExpressionParser.expectNumberOfTokens(remaining, 5);
        if (remaining.get(2).getType() != EQueryTokenType.PAREN_OPEN) {
            throw new QueryParsingException("Expected an opening bracket before the sub query definition.", remaining);
        }
        if ((remaining = remaining.subList(3, remaining.size())).get(0).getType() == EQueryTokenType.LITERAL && remaining.get(1).getType() == EQueryTokenType.PAREN_CLOSE) {
            throw new IllegalArgumentException("Named sub queries are supposed to be replaced in a preprocessing step.");
        }
        PartialParsingResult subQuery = QueryParser.createAndQuery(remaining);
        remaining = subQuery.getRemainingTokens();
        PartialQueryExpressionParser.expectNumberOfTokens(remaining, 1);
        if (remaining.get(0).getType() != EQueryTokenType.PAREN_CLOSE) {
            throw new QueryParsingException("Expected a closing bracket after the sub query definition.", remaining);
        }
        CCSMAssert.isInstanceOf((Object)leftAttributeAndRemainingTokens.getOperand(), AttributeOperand.class);
        AttributeOperand lhsAttribute = (AttributeOperand)leftAttributeAndRemainingTokens.getOperand();
        InSubQuery query = new InSubQuery(lhsAttribute, subQuery.getQuery());
        return new PartialParsingResult(query, remaining.subList(1, remaining.size()));
    }

    private static PartialParsingResult createInStateQuery(List<QueryToken> tokens) throws QueryParsingException {
        IQuery query;
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.IN_STATE, tokens.get(0));
        PartialParsingResult result = QueryParser.createParenthesizedQuery(tokens.subList(1, tokens.size()));
        List<QueryToken> remaining = result.getRemainingTokens();
        PartialQueryExpressionParser.expectNumberOfTokens(remaining, 2);
        QueryToken durationToken = remaining.get(1);
        try {
            query = QueryParser.buildInStateQueryWithDateDuration(result, remaining.get(0), QueryParser.parseDateDuration(durationToken));
        }
        catch (DateTimeParseException e) {
            query = QueryParser.buildInStateQuery(result, remaining.get(0), QueryParser.parseDuration(durationToken));
        }
        return new PartialParsingResult(query, remaining.subList(2, remaining.size()));
    }

    private static IQuery buildInStateQueryWithDateDuration(PartialParsingResult result, QueryToken comparatorToken, long duration) throws QueryParsingException {
        long dayInMs = 86400000L;
        switch (comparatorToken.getType()) {
            case SMALLER_THAN_OR_EQUAL: {
                duration -= dayInMs;
            }
            case SMALLER_THAN: {
                return new InStateQuery(result.getQuery(), duration);
            }
            case GREATER_THAN: {
                duration -= dayInMs;
            }
            case GREATER_THAN_OR_EQUAL: {
                return new AndQuery(result.getQuery(), new NotQuery(new InStateQuery(result.getQuery(), duration)));
            }
        }
        throw new QueryParsingException("Expected inState expression to be followed by comparison operator, but had " + comparatorToken.getText() + ".", comparatorToken);
    }

    private static IQuery buildInStateQuery(PartialParsingResult result, QueryToken comparatorToken, long duration) throws QueryParsingException {
        switch (comparatorToken.getType()) {
            case GREATER_THAN: {
                ++duration;
            }
            case GREATER_THAN_OR_EQUAL: {
                return new InStateQuery(result.getQuery(), duration);
            }
            case SMALLER_THAN_OR_EQUAL: {
                ++duration;
            }
            case SMALLER_THAN: {
                return new AndQuery(result.getQuery(), new NotQuery(new InStateQuery(result.getQuery(), duration)));
            }
        }
        throw new QueryParsingException("Expected inState expression to be followed by comparison operator, but had " + comparatorToken.getText() + ".", comparatorToken);
    }

    private static PartialParsingResult createHasParentQuery(List<QueryToken> tokens) throws QueryParsingException {
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.HAS_PARENT, tokens.get(0));
        PartialParsingResult subResult = QueryParser.createParenthesizedQuery(tokens.subList(1, tokens.size()));
        return new PartialParsingResult(new HasParentQuery(subResult.getQuery()), subResult.getRemainingTokens());
    }

    private static long parseDateDuration(QueryToken valueToken) throws QueryParsingException, DateTimeParseException {
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.LITERAL, valueToken);
        LocalDate parsedDate = LocalDate.parse(valueToken.getText().toLowerCase(), DATE_FORMAT);
        long timestamp = parsedDate.atStartOfDay(DateTimeUtils.getZone()).toInstant().toEpochMilli();
        long now = DateTimeUtils.millisNow();
        return now - timestamp + 1L;
    }

    private static long parseDuration(QueryToken valueToken) throws QueryParsingException {
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.LITERAL, valueToken);
        String text = valueToken.getText().toLowerCase();
        if (text.equalsIgnoreCase(START_OF_MONTH_LITERAL)) {
            ZonedDateTime startOfMonth = ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
            return Duration.between(startOfMonth, ZonedDateTime.now()).toMillis();
        }
        try {
            return StaticOperand.parseDurationLiteral(text);
        }
        catch (NumberFormatException e) {
            throw new QueryParsingException("Expected valid duration expression instead of " + valueToken.getText() + ".", valueToken);
        }
    }

    private static PartialParsingResult createReorderedNotQuery(List<QueryToken> tokens, List<QueryToken> remainingTokens) throws QueryParsingException {
        PartialQueryExpressionParser.expectNumberOfTokens(remainingTokens, 3);
        QueryToken notOperator = remainingTokens.get(0);
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.NOT, notOperator);
        ArrayList<QueryToken> modifiedTokens = new ArrayList<QueryToken>();
        modifiedTokens.add(notOperator);
        modifiedTokens.addAll(tokens.subList(0, tokens.size() - remainingTokens.size()));
        modifiedTokens.addAll(remainingTokens.subList(1, remainingTokens.size()));
        return QueryParser.createNotQuery(modifiedTokens);
    }

    private static PartialParsingResult createBasicExpression(PartialQueryExpression leftAttributeAndRemainingTokens) throws QueryParsingException {
        List<QueryToken> remainingTokens = leftAttributeAndRemainingTokens.getRemainingTokens();
        PartialQueryExpressionParser.expectNumberOfTokens(remainingTokens, 2);
        QueryToken operatorToken = remainingTokens.get(0);
        QueryToken rightSideValueToken = remainingTokens.get(1);
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.LITERAL, rightSideValueToken);
        StaticOperand rightSideValue = new StaticOperand(rightSideValueToken.getText());
        IQuery textQuery = QueryParser.createBasicQuery(leftAttributeAndRemainingTokens.getOperand(), operatorToken, rightSideValue);
        return new PartialParsingResult(textQuery, remainingTokens.subList(2, remainingTokens.size()));
    }

    private static IQuery createBasicQuery(IAttributeOperand leftHandSide, QueryToken operator, StaticOperand rightHandSide) throws QueryParsingException {
        switch (operator.getType()) {
            case EQUALS: {
                return new EqualsQuery(leftHandSide, rightHandSide);
            }
            case LIKE: {
                return new LikeQuery(leftHandSide, rightHandSide);
            }
            case GREATER_THAN: {
                return new ComparisonQuery(leftHandSide, rightHandSide, false, true);
            }
            case GREATER_THAN_OR_EQUAL: {
                return new ComparisonQuery(leftHandSide, rightHandSide, true, true);
            }
            case SMALLER_THAN: {
                return new ComparisonQuery(leftHandSide, rightHandSide, false, false);
            }
            case SMALLER_THAN_OR_EQUAL: {
                return new ComparisonQuery(leftHandSide, rightHandSide, true, false);
            }
        }
        throw new QueryParsingException("Expected valid basic operator (e.g '=', '<=', '>=') but had '" + operator.getText() + "'.", operator);
    }

    private static PartialParsingResult createListExpression(PartialQueryExpression leftAttributeAndRemainingTokens, boolean lenient) throws QueryParsingException {
        List<QueryToken> remainingTokens = leftAttributeAndRemainingTokens.getRemainingTokens();
        PartialQueryExpressionParser.expectNumberOfTokens(remainingTokens, 2);
        PartialQueryExpressionParser.expectTokenType(Set.of(EQueryTokenType.IN, EQueryTokenType.LIKE_IN), remainingTokens.get(0));
        QueryToken thirdToken = remainingTokens.get(1);
        PartialQueryExpressionParser.expectTokenType(EQueryTokenType.BRACKET_OPEN, thirdToken);
        int closingBracketIndex = QueryParser.findClosingBracketIndex(remainingTokens);
        List<String> attributeValues = QueryParser.extractLiteralsFromList(remainingTokens.subList(2, closingBracketIndex));
        IQuery query = QueryParser.createListQuery(leftAttributeAndRemainingTokens.getOperand(), attributeValues, lenient);
        return new PartialParsingResult(query, remainingTokens.subList(closingBracketIndex + 1, remainingTokens.size()));
    }

    private static IQuery createListQuery(IAttributeOperand attribute, List<String> values, boolean lenient) {
        return QueryParser.createAccumulatedOrQuery(CollectionUtils.map(values, value -> new EqualsQuery(attribute, new StaticOperand((String)value), lenient)));
    }

    private static IQuery createAccumulatedOrQuery(List<IQuery> queries) {
        return queries.stream().reduce(OrQuery::new).orElse(new FalseQuery());
    }

    private static List<String> extractLiteralsFromList(List<QueryToken> tokens) throws QueryParsingException {
        ArrayList<String> attributeValues = new ArrayList<String>();
        block4: for (QueryToken token : tokens) {
            switch (token.getType()) {
                case COMMA: {
                    continue block4;
                }
                case LITERAL: {
                    attributeValues.add(token.getText());
                    continue block4;
                }
            }
            throw new QueryParsingException("Expected literal, comma, star or bracket, but had '" + token.getText() + "'.", token);
        }
        return attributeValues;
    }

    private static PartialParsingResult createParenthesizedQuery(List<QueryToken> tokens) throws QueryParsingException {
        int closingParenIndex = QueryParser.findClosingParenIndex(tokens);
        List<QueryToken> remainingTokens = tokens.subList(closingParenIndex + 1, tokens.size());
        return new PartialParsingResult(QueryParser.createQuery(tokens.subList(1, closingParenIndex)), remainingTokens);
    }

    private static int findClosingParenIndex(List<QueryToken> tokens) throws QueryParsingException {
        int nesting = 0;
        block4: for (int i = 0; i < tokens.size(); ++i) {
            switch (tokens.get(i).getType()) {
                case PAREN_OPEN: {
                    ++nesting;
                    continue block4;
                }
                case PAREN_CLOSE: {
                    if (--nesting != 0) continue block4;
                    return i;
                }
            }
        }
        throw new QueryParsingException("No closing parenthesis found!", tokens);
    }

    private static int findClosingBracketIndex(List<QueryToken> tokens) throws QueryParsingException {
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() != EQueryTokenType.BRACKET_CLOSE) continue;
            return i;
        }
        throw new QueryParsingException("No closing bracket found!", tokens);
    }

    private static List<QueryToken> expectNonEmpty(List<QueryToken> tokens, String operatorName) throws QueryParsingException {
        if (tokens.isEmpty()) {
            throw new QueryParsingException("Expected further tokens after " + operatorName + ".", new QueryToken[0]);
        }
        return tokens;
    }
}

