/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.monitoring;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStorageSystemProviderDecorator;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStorageSystemProviderBase;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.engine.persistence.store.monitoring.OperationMonitor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class StorageSystemMonitor
implements IStorageSystemProviderDecorator {
    private final OperationMonitor getOperations;
    private final OperationMonitor putOperations;
    private final OperationMonitor removeOperations;
    private final OperationMonitor scanOperations;

    public StorageSystemMonitor(long slowThresholdNanos, OperationMonitor.ISlowOperationReporter slowOperationReporter) {
        this.getOperations = new OperationMonitor("get", slowThresholdNanos, slowOperationReporter);
        this.putOperations = new OperationMonitor("put", slowThresholdNanos, slowOperationReporter);
        this.removeOperations = new OperationMonitor("remove", slowThresholdNanos, slowOperationReporter);
        this.scanOperations = new OperationMonitor("scan", slowThresholdNanos, slowOperationReporter);
    }

    @Override
    public IStorageSystemProvider decorate(IStorageSystemProvider mainStorageSystemProvider) {
        return new DelegatingStorageSystemProviderBase(mainStorageSystemProvider){

            @Override
            protected IStore wrapStore(IStore store, String storeName, String storageSystemName) {
                return new MonitoringStore(store, storeName);
            }
        };
    }

    public List<OperationMonitor.OperationRates> reportAndResetAll() {
        return CollectionUtils.map(Arrays.asList(this.getOperations, this.putOperations, this.removeOperations, this.scanOperations), OperationMonitor::determineRatesAndReset);
    }

    @ThreadSafe
    private static class CountingKeyValueCallback
    implements IKeyValueCallback {
        private int count;
        private final IKeyValueCallback delegate;

        public CountingKeyValueCallback(IKeyValueCallback delegate) {
            this.delegate = delegate;
        }

        @Override
        public void callback(byte[] key, byte[] value) {
            this.increaseCount();
            this.delegate.callback(key, value);
        }

        private synchronized void increaseCount() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    protected class MonitoringStore
    implements IStore {
        private final IStore store;
        private final String storeName;

        public MonitoringStore(IStore store, String storeName) {
            this.store = store;
            this.storeName = storeName;
        }

        @Override
        public byte[] get(byte @NonNull [] key) throws StorageException {
            long start = System.nanoTime();
            byte[] result = this.store.get(key);
            StorageSystemMonitor.this.getOperations.reportOperation(start, 1, this.storeName);
            return result;
        }

        @Override
        public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
            long start = System.nanoTime();
            List<byte[]> result = this.store.get(keys);
            StorageSystemMonitor.this.getOperations.reportOperation(start, keys.size(), this.storeName);
            return result;
        }

        @Override
        public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
            long start = System.nanoTime();
            this.store.put(key, value);
            StorageSystemMonitor.this.putOperations.reportOperation(start, 1, this.storeName);
        }

        @Override
        public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
            long start = System.nanoTime();
            this.store.put(keysValues);
            StorageSystemMonitor.this.putOperations.reportOperation(start, keysValues.size(), this.storeName);
        }

        @Override
        public void remove(byte @NonNull [] key) throws StorageException {
            long start = System.nanoTime();
            this.store.remove(key);
            StorageSystemMonitor.this.removeOperations.reportOperation(start, 1, this.storeName);
        }

        @Override
        public void remove(List<byte @NonNull []> keys) throws StorageException {
            long start = System.nanoTime();
            this.store.remove(keys);
            StorageSystemMonitor.this.removeOperations.reportOperation(start, keys.size(), this.storeName);
        }

        @Override
        public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
            long start = System.nanoTime();
            this.store.removeByPrefix(prefix);
            StorageSystemMonitor.this.removeOperations.reportOperation(start, 1, this.storeName);
        }

        @Override
        public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            CountingKeyValueCallback countingCallback = new CountingKeyValueCallback(callback);
            this.store.scan(beginKey, endKey, countingCallback);
            StorageSystemMonitor.this.scanOperations.reportOperation(start, countingCallback.getCount(), this.storeName);
        }

        @Override
        public void scan(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            CountingKeyValueCallback countingCallback = new CountingKeyValueCallback(callback);
            this.store.scan(prefix, (IKeyValueCallback)countingCallback);
            StorageSystemMonitor.this.scanOperations.reportOperation(start, countingCallback.getCount(), this.storeName);
        }

        @Override
        public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
            long start = System.nanoTime();
            List countingCallbacks = CollectionUtils.map(callbacks, CountingKeyValueCallback::new);
            this.store.scan(prefixes, countingCallbacks);
            StorageSystemMonitor.this.scanOperations.reportOperation(start, countingCallbacks.stream().mapToInt(CountingKeyValueCallback::getCount).sum(), this.storeName);
        }

        @Override
        public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            CountingKeyValueCallback countingCallback = new CountingKeyValueCallback(callback);
            this.store.scanKeys(beginKey, endKey, countingCallback);
            StorageSystemMonitor.this.scanOperations.reportOperation(start, countingCallback.getCount(), this.storeName);
        }

        @Override
        public void scanKeys(byte @NonNull [] prefix, IKeyValueCallback callback) throws StorageException {
            long start = System.nanoTime();
            CountingKeyValueCallback countingCallback = new CountingKeyValueCallback(callback);
            this.store.scanKeys(prefix, (IKeyValueCallback)countingCallback);
            StorageSystemMonitor.this.scanOperations.reportOperation(start, countingCallback.getCount(), this.storeName);
        }

        @Override
        public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
            long start = System.nanoTime();
            List countingCallbacks = CollectionUtils.map(callbacks, CountingKeyValueCallback::new);
            this.store.scanKeys(prefixes, countingCallbacks);
            StorageSystemMonitor.this.scanOperations.reportOperation(start, countingCallbacks.stream().mapToInt(CountingKeyValueCallback::getCount).sum(), this.storeName);
        }

        @Override
        public Lock obtainLock(String suffix) {
            return this.store.obtainLock(suffix);
        }

        @Override
        public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
            return this.store.getCapability(capability);
        }
    }
}

