/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class Condition {
    private static final Set<ETokenType.ETokenClass> WORD_TOKEN_CLASSES = EnumSet.of(ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.LITERAL, ETokenType.ETokenClass.KEYWORD);
    private final List<IToken> tokens = new ArrayList<IToken>();

    public Condition() {
        this(new ArrayList<IToken>());
    }

    public Condition(List<IToken> tokens) {
        CCSMAssert.isNotNull(tokens);
        this.tokens.addAll(tokens);
    }

    public void appendToken(IToken token) {
        CCSMAssert.isNotNull((Object)token);
        this.tokens.add(token);
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public UnmodifiableList<IToken> getTokens() {
        return CollectionUtils.asUnmodifiable(this.tokens);
    }

    public boolean isEmptyOrSingleLiteral() {
        return this.isEmpty() || this.isSingleLiteral();
    }

    public boolean isSingleLiteral() {
        return this.tokens.size() == 1 && this.tokens.get(0).getType().getTokenClass() == ETokenType.ETokenClass.LITERAL;
    }

    public int getLineNumber() {
        if (this.tokens.isEmpty()) {
            return -1;
        }
        return this.tokens.get(0).getLineNumber() + 1;
    }

    public Condition cleanupParenthesesAndNegation() {
        ArrayList<IToken> tokens = new ArrayList<IToken>(this.tokens);
        while (!tokens.isEmpty() && ((IToken)tokens.get(0)).getType() == ETokenType.NOT) {
            tokens.remove(0);
        }
        return new Condition(tokens).cleanupAllParentheses();
    }

    public Condition cleanupAllParentheses() {
        List<IToken> tokens = new ArrayList<IToken>(this.tokens);
        tokens = Condition.removeEndOfLineTokens(tokens);
        Condition.removeUnbalancedParentheses(tokens);
        Condition.removeBalancedOutermostParentheses(tokens);
        return new Condition(tokens);
    }

    public Condition cleanupBalancedParentheses() {
        List<IToken> tokens = new ArrayList<IToken>(this.tokens);
        tokens = Condition.removeEndOfLineTokens(tokens);
        Condition.removeBalancedOutermostParentheses(tokens);
        return new Condition(tokens);
    }

    private static void removeBalancedOutermostParentheses(List<IToken> tokens) {
        PairList properlyNestedParentheses = new PairList();
        Stack<Integer> openParentheses = new Stack<Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (tokens.get(i).getType() == ETokenType.LPAREN) {
                openParentheses.push(i);
                continue;
            }
            if (tokens.get(i).getType() != ETokenType.RPAREN) continue;
            properlyNestedParentheses.add((Object)((Integer)openParentheses.pop()), (Object)i);
        }
        int removedPairs = 0;
        int originalSize = tokens.size();
        for (int i = properlyNestedParentheses.size() - 1; i >= 0 && (Integer)properlyNestedParentheses.getFirst(i) == removedPairs && (Integer)properlyNestedParentheses.getSecond(i) == originalSize - removedPairs - 1; ++removedPairs, --i) {
            tokens.remove(0);
            tokens.remove(tokens.size() - 1);
        }
    }

    private static List<IToken> removeEndOfLineTokens(List<IToken> tokens) {
        return CollectionUtils.filter(tokens, t -> t.getType() != ETokenType.EOL);
    }

    private static void removeUnbalancedParentheses(List<IToken> tokens) {
        Stack<Integer> openParentheses = new Stack<Integer>();
        block4: for (int i = 0; i < tokens.size(); ++i) {
            switch (tokens.get(i).getType()) {
                case LPAREN: {
                    openParentheses.push(i);
                    continue block4;
                }
                case RPAREN: {
                    if (openParentheses.isEmpty()) {
                        tokens.remove(i);
                        --i;
                        continue block4;
                    }
                    openParentheses.pop();
                }
            }
        }
        while (!openParentheses.isEmpty()) {
            tokens.remove((Integer)openParentheses.pop());
        }
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        boolean previousIsWord = false;
        for (IToken token : this.tokens) {
            boolean isWord = Condition.isWordToken(token);
            if (previousIsWord && isWord) {
                builder.append(" ");
            }
            previousIsWord = isWord;
            builder.append(token.getText());
        }
        return builder.toString();
    }

    private static boolean isWordToken(IToken token) {
        ETokenType.ETokenClass tokenClass = token.getType().getTokenClass();
        return WORD_TOKEN_CLASSES.contains(tokenClass) || tokenClass == ETokenType.ETokenClass.OPERATOR && Character.isAlphabetic(token.getText().charAt(0));
    }

    public String toString() {
        if (this.tokens.isEmpty()) {
            return "";
        }
        return "[" + this.getText() + "] (" + this.getLineNumber() + ")";
    }

    public boolean equals(Object other) {
        if (other instanceof Condition) {
            return this.cleanupBalancedParentheses().getText().equals(((Condition)other).cleanupBalancedParentheses().getText());
        }
        return false;
    }

    public int hashCode() {
        return this.getText().hashCode();
    }
}

