/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionExtractor;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class ConditionExtractorBase
implements IConditionExtractor {
    private final Set<ETokenType> booleanResultOperators;

    protected ConditionExtractorBase(Set<ETokenType> booleanResultOperators) {
        this.booleanResultOperators = booleanResultOperators;
    }

    @Override
    public Condition extractGeneralCondition(List<IToken> tokens) throws ConQATException {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        this.extractGeneralConditions(ConditionExtractorBase.eliminateTemplates(tokens), conditions);
        if (conditions.isEmpty()) {
            return null;
        }
        return Collections.max(conditions, Comparator.comparingInt(condition -> condition.getTokens().size()));
    }

    private static List<IToken> eliminateTemplates(List<IToken> tokens) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        ArrayList<IToken> templateBuffer = new ArrayList<IToken>();
        for (IToken token : tokens) {
            ETokenType type = token.getType();
            if (templateBuffer.isEmpty()) {
                if (type == ETokenType.LT) {
                    templateBuffer.add(token);
                    continue;
                }
                result.add(token);
                continue;
            }
            if (ConditionExtractorBase.canCloseTemplate(templateBuffer.size()) && type == ETokenType.GT) {
                templateBuffer.clear();
                continue;
            }
            if (ConditionExtractorBase.templateContinuationType(templateBuffer.size()) == type) {
                templateBuffer.add(token);
                continue;
            }
            result.addAll(templateBuffer);
            templateBuffer.clear();
            result.add(token);
        }
        return result;
    }

    private static boolean canCloseTemplate(int numberOfPreviousTokens) {
        return numberOfPreviousTokens > 1 && numberOfPreviousTokens % 2 == 0;
    }

    private static ETokenType templateContinuationType(int numberOfPreviousTokens) {
        if (numberOfPreviousTokens % 2 == 0) {
            return ETokenType.COMMA;
        }
        return ETokenType.IDENTIFIER;
    }

    private void extractGeneralConditions(List<IToken> tokens, List<Condition> conditions) throws ConQATException {
        ArrayList<IToken> withoutMethods = new ArrayList<IToken>();
        int methodCallNesting = this.calculateNestingDepthAndFiltersMethodCalls(tokens, conditions, withoutMethods);
        if (methodCallNesting >= 0) {
            throw new ConQATException("Misbalanced parentheses!");
        }
        this.extractGeneralConditionWithoutCall(withoutMethods, conditions);
    }

    private int calculateNestingDepthAndFiltersMethodCalls(List<IToken> tokens, List<Condition> conditions, List<IToken> withoutMethods) throws ConQATException {
        int methodCallNesting = -1;
        ETokenType previousTokenType = null;
        ArrayList<IToken> methodParameterBuffer = new ArrayList<IToken>();
        for (IToken token : tokens) {
            ETokenType type = token.getType();
            if (methodCallNesting < 0) {
                if ((type == ETokenType.LPAREN || type == ETokenType.LBRACK) && previousTokenType == ETokenType.IDENTIFIER) {
                    methodCallNesting = 0;
                    previousTokenType = null;
                    withoutMethods.set(withoutMethods.size() - 1, ConditionExtractorBase.extendMethodToken((IToken)CollectionUtils.getLast(withoutMethods), type));
                    continue;
                }
                withoutMethods.add(token);
                previousTokenType = type;
                continue;
            }
            methodCallNesting = this.calculateNestingDepthAndFiltersMethodCalls(conditions, token, type, methodCallNesting, methodParameterBuffer);
        }
        return methodCallNesting;
    }

    private int calculateNestingDepthAndFiltersMethodCalls(List<Condition> conditions, IToken token, ETokenType type, int methodCallNesting, List<IToken> methodParameterBuffer) throws ConQATException {
        switch (type) {
            case LPAREN: 
            case LBRACK: {
                ++methodCallNesting;
                break;
            }
            case RPAREN: 
            case RBRACK: {
                if (methodCallNesting == 0) {
                    this.extractGeneralConditions(methodParameterBuffer, conditions);
                    methodParameterBuffer.clear();
                }
                --methodCallNesting;
                break;
            }
            case COMMA: {
                if (methodCallNesting != 0) break;
                this.extractGeneralConditions(methodParameterBuffer, conditions);
                methodParameterBuffer.clear();
                break;
            }
            default: {
                methodParameterBuffer.add(token);
            }
        }
        return methodCallNesting;
    }

    private static IToken extendMethodToken(IToken token, ETokenType parenthesisType) {
        String extension = "(...)";
        if (parenthesisType == ETokenType.LBRACK) {
            extension = "[...]";
        }
        return token.newToken(ETokenType.IDENTIFIER, token.getOffset(), token.getLineNumber(), token.getText() + extension, token.getOriginId());
    }

    protected void extractGeneralConditionWithoutCall(List<IToken> tokens, List<Condition> conditions) {
        int i;
        int firstMatch;
        for (firstMatch = 1; firstMatch < tokens.size() && !this.isBooleanResultOperator(tokens, firstMatch); ++firstMatch) {
        }
        if (firstMatch >= tokens.size()) {
            return;
        }
        int lastMatch = tokens.size() - 2;
        if (lastMatch < firstMatch) {
            return;
        }
        while (!this.isBooleanResultOperator(tokens, lastMatch)) {
            --lastMatch;
        }
        if (!ConditionExtractorBase.isNegation(tokens, firstMatch)) {
            --firstMatch;
        }
        ++lastMatch;
        int minOpen = 0;
        int balance = 0;
        for (i = firstMatch; i <= lastMatch; ++i) {
            balance = ConditionExtractorBase.updateParenthesisBalance(balance, tokens.get(i));
            minOpen = Math.min(balance, minOpen);
        }
        while (minOpen < 0 && firstMatch > 0) {
            minOpen = ConditionExtractorBase.updateParenthesisBalance(minOpen, tokens.get(--firstMatch));
        }
        balance = 0;
        for (i = firstMatch; i <= lastMatch; ++i) {
            balance = ConditionExtractorBase.updateParenthesisBalance(balance, tokens.get(i));
        }
        while (balance > 0 && lastMatch < tokens.size() - 1) {
            balance = ConditionExtractorBase.updateParenthesisBalance(balance, tokens.get(++lastMatch));
        }
        conditions.add(new Condition(tokens.subList(firstMatch, lastMatch + 1)));
    }

    private static int updateParenthesisBalance(int balance, IToken token) {
        return switch (token.getType()) {
            case ETokenType.LPAREN -> balance + 1;
            case ETokenType.RPAREN -> balance - 1;
            default -> balance;
        };
    }

    private boolean isBooleanResultOperator(List<IToken> tokens, int index) {
        return this.booleanResultOperators.contains(tokens.get(index).getType()) && !this.isPartOfDoubleOperator(index, tokens);
    }

    protected static boolean isNegation(List<IToken> tokens, int index) {
        return tokens.get(index).getType() == ETokenType.NOT;
    }

    private boolean isPartOfDoubleOperator(int index, List<IToken> tokens) {
        boolean isDoubleOperatorBefore = index > 0 && this.isDoubleOperator(tokens.get(index - 1).getType(), tokens.get(index).getType());
        boolean isDoubleOperatorAfter = index < tokens.size() - 1 && this.isDoubleOperator(tokens.get(index).getType(), tokens.get(index + 1).getType());
        return isDoubleOperatorBefore || isDoubleOperatorAfter;
    }

    protected abstract boolean isDoubleOperator(ETokenType var1, ETokenType var2);
}

