/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.ByteBuffer;
import org.rocksdb.AbstractComparator;

class AbstractComparatorJniBridge {
    AbstractComparatorJniBridge() {
    }

    private static int compareInternal(AbstractComparator comparator, ByteBuffer a, int aLen, ByteBuffer b, int bLen) {
        if (aLen != -1) {
            a.mark();
            a.limit(aLen);
        }
        if (bLen != -1) {
            b.mark();
            b.limit(bLen);
        }
        int c = comparator.compare(a, b);
        if (aLen != -1) {
            a.reset();
        }
        if (bLen != -1) {
            b.reset();
        }
        return c;
    }

    private static int findShortestSeparatorInternal(AbstractComparator comparator, ByteBuffer start, int startLen, ByteBuffer limit, int limitLen) {
        if (startLen != -1) {
            start.limit(startLen);
        }
        if (limitLen != -1) {
            limit.limit(limitLen);
        }
        comparator.findShortestSeparator(start, limit);
        return start.remaining();
    }

    private static int findShortSuccessorInternal(AbstractComparator comparator, ByteBuffer key, int keyLen) {
        if (keyLen != -1) {
            key.limit(keyLen);
        }
        comparator.findShortSuccessor(key);
        return key.remaining();
    }
}

