/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.io.Closeable;
import java.io.IOException;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Char;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.ObjectStruct;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Sparse;
import us.hebi.matlab.mat.types.Struct;
import us.hebi.matlab.mat.util.Preconditions;

public interface MatFile
extends Closeable {
    public Matrix getMatrix(String var1);

    public Sparse getSparse(String var1);

    public Char getChar(String var1);

    public Struct getStruct(String var1);

    public ObjectStruct getObject(String var1);

    public Cell getCell(String var1);

    public Matrix getMatrix(int var1);

    public Sparse getSparse(int var1);

    public Char getChar(int var1);

    public Struct getStruct(int var1);

    public ObjectStruct getObject(int var1);

    public Cell getCell(int var1);

    public <T extends Array> T getArray(String var1);

    public <T extends Array> T getArray(int var1);

    public MatFile addArray(String var1, Array var2);

    public MatFile addArray(String var1, boolean var2, Array var3);

    public MatFile addEntry(Entry var1);

    public int getNumEntries();

    public Iterable<Entry> getEntries();

    public Entry getSubsystem();

    public void clear();

    @Override
    public void close() throws IOException;

    public long getUncompressedSerializedSize();

    public MatFile writeTo(Sink var1) throws IOException;

    public static final class Entry {
        private final String name;
        private final Array value;
        private final boolean isGlobal;

        public Entry(String name, boolean isGlobal, Array value) {
            this.name = Preconditions.checkNotNull(name, "Name can't be null");
            this.value = Preconditions.checkNotNull(value, "Value can't be null");
            this.isGlobal = isGlobal;
        }

        public String getName() {
            return this.name;
        }

        public Array getValue() {
            return this.value;
        }

        public boolean isGlobal() {
            return this.isGlobal;
        }

        public String toString() {
            return this.name + (this.isGlobal() ? " (global)" : "") + " = " + this.value;
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.value.hashCode() + (this.isGlobal ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Entry) {
                Entry other = (Entry)obj;
                return other.name.equals(this.name) && other.value.equals(this.value) && other.isGlobal == this.isGlobal;
            }
            return false;
        }
    }
}

