/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.distributedtask.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.AzureSubscriptionQueryResult;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.DataSourceBinding;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.MetaTaskDefinition;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.PackageMetadata;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.ServiceEndpoint;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.ServiceEndpointRequest;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.ServiceEndpointRequestResult;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.ServiceEndpointType;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskAgent;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskAgentJobRequest;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskAgentMessage;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskAgentPool;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskAgentQueue;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskAgentQueueActionFilter;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskAgentSession;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskDefinition;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskDefinitionEndpoint;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskGroup;
import com.microsoft.alm.teamfoundation.distributedtask.webapi.TaskHubLicenseDetails;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.alm.visualstudio.services.webapi.IdentityRef;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class TaskAgentHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected TaskAgentHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public TaskAgent addAgent(TaskAgent agent, int poolId) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, agent, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgent.class);
    }

    public void deleteAgent(int poolId, int agentId) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TaskAgent getAgent(int poolId, int agentId, Boolean includeCapabilities, Boolean includeAssignedRequest, List<String> propertyFilters) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeCapabilities", includeCapabilities);
        queryParameters.addIfNotNull("includeAssignedRequest", includeAssignedRequest);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskAgent.class);
    }

    public ArrayList<TaskAgent> getAgents(int poolId, String agentName, Boolean includeCapabilities, Boolean includeAssignedRequest, List<String> propertyFilters, List<String> demands) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("agentName", agentName);
        queryParameters.addIfNotNull("includeCapabilities", includeCapabilities);
        queryParameters.addIfNotNull("includeAssignedRequest", includeAssignedRequest);
        queryParameters.addIfNotNull("propertyFilters", propertyFilters);
        queryParameters.addIfNotNull("demands", demands);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAgent>>(){});
    }

    public TaskAgent replaceAgent(TaskAgent agent, int poolId, int agentId) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, agent, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgent.class);
    }

    public TaskAgent updateAgent(TaskAgent agent, int poolId, int agentId) {
        UUID locationId = UUID.fromString("e298ef32-5878-4cab-993c-043836571f42");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, agent, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgent.class);
    }

    public AzureSubscriptionQueryResult getAzureSubscriptions() {
        UUID locationId = UUID.fromString("bcd6189c-0303-471f-a8e1-acb22b74d700");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, AzureSubscriptionQueryResult.class);
    }

    public ArrayList<String> queryEndpoint(TaskDefinitionEndpoint endpoint) {
        UUID locationId = UUID.fromString("f223b809-8c33-4b7d-b53f-07232569b5d6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, endpoint, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public TaskHubLicenseDetails getTaskHubLicenseDetails(String hubName, Boolean includeEnterpriseUsersCount) {
        UUID locationId = UUID.fromString("f9f0f436-b8a1-4475-9041-1ccdbf8f0128");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("hubName", hubName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("includeEnterpriseUsersCount", includeEnterpriseUsersCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskHubLicenseDetails.class);
    }

    public TaskHubLicenseDetails updateTaskHubLicenseDetails(TaskHubLicenseDetails taskHubLicenseDetails, String hubName) {
        UUID locationId = UUID.fromString("f9f0f436-b8a1-4475-9041-1ccdbf8f0128");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("hubName", hubName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, taskHubLicenseDetails, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskHubLicenseDetails.class);
    }

    public InputStream getTaskIcon(UUID taskId, String versionString) {
        UUID locationId = UUID.fromString("63463108-174d-49d4-b8cb-235eea42a5e1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("taskId", taskId);
        routeValues.put("versionString", versionString);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public void deleteAgentRequest(int poolId, long requestId, UUID lockToken) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("requestId", requestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("lockToken", lockToken);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public TaskAgentJobRequest getAgentRequest(int poolId, long requestId) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("requestId", requestId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, TaskAgentJobRequest.class);
    }

    public ArrayList<TaskAgentJobRequest> getAgentRequestsForAgent(int poolId, int agentId, Integer completedRequestCount) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("agentId", String.valueOf(agentId));
        queryParameters.addIfNotNull("completedRequestCount", completedRequestCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAgentJobRequest>>(){});
    }

    public ArrayList<TaskAgentJobRequest> getAgentRequestsForAgents(int poolId, List<Integer> agentIds, Integer completedRequestCount) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("agentIds", agentIds);
        queryParameters.addIfNotNull("completedRequestCount", completedRequestCount);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAgentJobRequest>>(){});
    }

    public ArrayList<TaskAgentJobRequest> getAgentRequestsForPlan(int poolId, UUID planId, UUID jobId) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("planId", planId);
        queryParameters.addIfNotNull("jobId", jobId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAgentJobRequest>>(){});
    }

    public TaskAgentJobRequest queueAgentRequest(TaskAgentJobRequest request, int poolId) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, request, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgentJobRequest.class);
    }

    public TaskAgentJobRequest updateAgentRequest(TaskAgentJobRequest request, int poolId, long requestId, UUID lockToken) {
        UUID locationId = UUID.fromString("fc825784-c92a-4299-9221-998a02d1b54f");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("requestId", requestId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("lockToken", lockToken);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, request, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskAgentJobRequest.class);
    }

    public void deleteMessage(int poolId, long messageId, UUID sessionId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("messageId", messageId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("sessionId", sessionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public TaskAgentMessage getMessage(int poolId, UUID sessionId, Integer lastMessageId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("sessionId", sessionId);
        queryParameters.addIfNotNull("lastMessageId", lastMessageId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskAgentMessage.class);
    }

    public void refreshAgent(int poolId, int agentId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("agentId", String.valueOf(agentId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public void refreshAgents(int poolId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void sendMessage(TaskAgentMessage message, int poolId, long requestId) {
        UUID locationId = UUID.fromString("c3a054f6-7a8a-49c0-944e-3a8e5d7adfd7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.put("requestId", String.valueOf(requestId));
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, message, "application/json", queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public MetaTaskDefinition addMetaTaskDefinition(MetaTaskDefinition definition, String project) {
        UUID locationId = UUID.fromString("71aa53a2-0ce0-46f2-856b-8cbc1cdffa4e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, definition, "application/json", "application/json");
        return super.sendRequest(httpRequest, MetaTaskDefinition.class);
    }

    public MetaTaskDefinition addMetaTaskDefinition(MetaTaskDefinition definition, UUID project) {
        UUID locationId = UUID.fromString("71aa53a2-0ce0-46f2-856b-8cbc1cdffa4e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, definition, "application/json", "application/json");
        return super.sendRequest(httpRequest, MetaTaskDefinition.class);
    }

    public void deleteMetaTaskDefinition(String project, UUID metaTaskDefinitionId) {
        UUID locationId = UUID.fromString("71aa53a2-0ce0-46f2-856b-8cbc1cdffa4e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("metaTaskDefinitionId", metaTaskDefinitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteMetaTaskDefinition(UUID project, UUID metaTaskDefinitionId) {
        UUID locationId = UUID.fromString("71aa53a2-0ce0-46f2-856b-8cbc1cdffa4e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("metaTaskDefinitionId", metaTaskDefinitionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<MetaTaskDefinition> getMetaTaskDefinitions(String project, UUID metaTaskDefinitionId, Boolean expanded) {
        UUID locationId = UUID.fromString("71aa53a2-0ce0-46f2-856b-8cbc1cdffa4e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("metaTaskDefinitionId", metaTaskDefinitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("expanded", expanded);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<MetaTaskDefinition>>(){});
    }

    public ArrayList<MetaTaskDefinition> getMetaTaskDefinitions(UUID project, UUID metaTaskDefinitionId, Boolean expanded) {
        UUID locationId = UUID.fromString("71aa53a2-0ce0-46f2-856b-8cbc1cdffa4e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("metaTaskDefinitionId", metaTaskDefinitionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("expanded", expanded);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<MetaTaskDefinition>>(){});
    }

    public MetaTaskDefinition updateMetaTaskDefinition(MetaTaskDefinition definition, String project) {
        UUID locationId = UUID.fromString("71aa53a2-0ce0-46f2-856b-8cbc1cdffa4e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, definition, "application/json", "application/json");
        return super.sendRequest(httpRequest, MetaTaskDefinition.class);
    }

    public MetaTaskDefinition updateMetaTaskDefinition(MetaTaskDefinition definition, UUID project) {
        UUID locationId = UUID.fromString("71aa53a2-0ce0-46f2-856b-8cbc1cdffa4e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, definition, "application/json", "application/json");
        return super.sendRequest(httpRequest, MetaTaskDefinition.class);
    }

    public PackageMetadata getPackage(String packageType, String platform, String version) {
        UUID locationId = UUID.fromString("8ffcd551-079c-493a-9c02-54346299d144");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("packageType", packageType);
        routeValues.put("platform", platform);
        routeValues.put("version", version);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, PackageMetadata.class);
    }

    public ArrayList<PackageMetadata> getPackages(String packageType, String platform, Integer top) {
        UUID locationId = UUID.fromString("8ffcd551-079c-493a-9c02-54346299d144");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("packageType", packageType);
        routeValues.put("platform", platform);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("$top", top);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<PackageMetadata>>(){});
    }

    public ArrayList<IdentityRef> getAgentPoolRoles(Integer poolId) {
        UUID locationId = UUID.fromString("381dd2bb-35cf-4103-ae8c-3c815b25763c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRef>>(){});
    }

    public TaskAgentPool addAgentPool(TaskAgentPool pool) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, pool, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgentPool.class);
    }

    public void deleteAgentPool(int poolId) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TaskAgentPool getAgentPool(int poolId, List<String> properties) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("properties", properties);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskAgentPool.class);
    }

    public ArrayList<TaskAgentPool> getAgentPools(String poolName, List<String> properties) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("poolName", poolName);
        queryParameters.addIfNotNull("properties", properties);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAgentPool>>(){});
    }

    public TaskAgentPool updateAgentPool(TaskAgentPool pool, int poolId) {
        UUID locationId = UUID.fromString("a8c47e17-4d56-4a56-92bb-de7ea7dc65be");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, pool, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgentPool.class);
    }

    public ArrayList<IdentityRef> getAgentQueueRoles(Integer queueId) {
        UUID locationId = UUID.fromString("b0c6d64d-c9fa-4946-b8de-77de623ee585");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("queueId", queueId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<IdentityRef>>(){});
    }

    public TaskAgentQueue addAgentQueue(TaskAgentQueue queue) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, queue, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgentQueue.class);
    }

    public TaskAgentQueue addAgentQueue(TaskAgentQueue queue, String project) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queue, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgentQueue.class);
    }

    public TaskAgentQueue addAgentQueue(TaskAgentQueue queue, UUID project) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queue, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgentQueue.class);
    }

    public void createQueuesForAgentPools() {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void createQueuesForAgentPools(String project) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void createQueuesForAgentPools(UUID project) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteAgentQueue(int queueId) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("queueId", queueId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteAgentQueue(String project, int queueId) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("queueId", queueId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteAgentQueue(UUID project, int queueId) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("queueId", queueId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TaskAgentQueue getAgentQueue(String project, int queueId, TaskAgentQueueActionFilter actionFilter) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("queueId", queueId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("actionFilter", actionFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskAgentQueue.class);
    }

    public TaskAgentQueue getAgentQueue(UUID project, int queueId, TaskAgentQueueActionFilter actionFilter) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("queueId", queueId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("actionFilter", actionFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskAgentQueue.class);
    }

    public TaskAgentQueue getAgentQueue(int queueId, TaskAgentQueueActionFilter actionFilter) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("queueId", queueId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("actionFilter", actionFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskAgentQueue.class);
    }

    public ArrayList<TaskAgentQueue> getAgentQueues(String project, String queueName, TaskAgentQueueActionFilter actionFilter) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("queueName", queueName);
        queryParameters.addIfNotNull("actionFilter", actionFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAgentQueue>>(){});
    }

    public ArrayList<TaskAgentQueue> getAgentQueues(UUID project, String queueName, TaskAgentQueueActionFilter actionFilter) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("queueName", queueName);
        queryParameters.addIfNotNull("actionFilter", actionFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAgentQueue>>(){});
    }

    public ArrayList<TaskAgentQueue> getAgentQueues(String queueName, TaskAgentQueueActionFilter actionFilter) {
        UUID locationId = UUID.fromString("900fa995-c559-4923-aae7-f8424fe4fbea");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("queueName", queueName);
        queryParameters.addIfNotNull("actionFilter", actionFilter);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskAgentQueue>>(){});
    }

    public ServiceEndpointRequestResult executeServiceEndpointRequest(ServiceEndpointRequest serviceEndpointRequest, String project, String endpointId) {
        UUID locationId = UUID.fromString("f956a7de-d766-43af-81b1-e9e349245634");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("endpointId", endpointId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, serviceEndpointRequest, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, ServiceEndpointRequestResult.class);
    }

    public ServiceEndpointRequestResult executeServiceEndpointRequest(ServiceEndpointRequest serviceEndpointRequest, UUID project, String endpointId) {
        UUID locationId = UUID.fromString("f956a7de-d766-43af-81b1-e9e349245634");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("endpointId", endpointId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, serviceEndpointRequest, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, ServiceEndpointRequestResult.class);
    }

    public ArrayList<String> queryServiceEndpoint(DataSourceBinding binding, String project) {
        UUID locationId = UUID.fromString("f956a7de-d766-43af-81b1-e9e349245634");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, binding, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ArrayList<String> queryServiceEndpoint(DataSourceBinding binding, UUID project) {
        UUID locationId = UUID.fromString("f956a7de-d766-43af-81b1-e9e349245634");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, binding, "application/json", "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public ServiceEndpoint createServiceEndpoint(ServiceEndpoint endpoint, String project) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, endpoint, "application/json", "application/json");
        return super.sendRequest(httpRequest, ServiceEndpoint.class);
    }

    public ServiceEndpoint createServiceEndpoint(ServiceEndpoint endpoint, UUID project) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, endpoint, "application/json", "application/json");
        return super.sendRequest(httpRequest, ServiceEndpoint.class);
    }

    public void deleteServiceEndpoint(String project, UUID endpointId) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("endpointId", endpointId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteServiceEndpoint(UUID project, UUID endpointId) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("endpointId", endpointId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ServiceEndpoint getServiceEndpointDetails(String project, UUID endpointId) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("endpointId", endpointId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ServiceEndpoint.class);
    }

    public ServiceEndpoint getServiceEndpointDetails(UUID project, UUID endpointId) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("endpointId", endpointId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, ServiceEndpoint.class);
    }

    public ArrayList<ServiceEndpoint> getServiceEndpoints(String project, String type, List<String> authSchemes, List<UUID> endpointIds, Boolean includeFailed) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("type", type);
        queryParameters.addIfNotNull("authSchemes", authSchemes);
        queryParameters.addIfNotNull("endpointIds", endpointIds);
        queryParameters.addIfNotNull("includeFailed", includeFailed);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ServiceEndpoint>>(){});
    }

    public ArrayList<ServiceEndpoint> getServiceEndpoints(UUID project, String type, List<String> authSchemes, List<UUID> endpointIds, Boolean includeFailed) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("type", type);
        queryParameters.addIfNotNull("authSchemes", authSchemes);
        queryParameters.addIfNotNull("endpointIds", endpointIds);
        queryParameters.addIfNotNull("includeFailed", includeFailed);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ServiceEndpoint>>(){});
    }

    public ServiceEndpoint updateServiceEndpoint(ServiceEndpoint endpoint, String project, UUID endpointId) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("endpointId", endpointId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, endpoint, "application/json", "application/json");
        return super.sendRequest(httpRequest, ServiceEndpoint.class);
    }

    public ServiceEndpoint updateServiceEndpoint(ServiceEndpoint endpoint, UUID project, UUID endpointId) {
        UUID locationId = UUID.fromString("dca61d2f-3444-410a-b5ec-db2fc4efb4c5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.2");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("endpointId", endpointId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, endpoint, "application/json", "application/json");
        return super.sendRequest(httpRequest, ServiceEndpoint.class);
    }

    public ArrayList<ServiceEndpointType> getServiceEndpointTypes(String type, String scheme) {
        UUID locationId = UUID.fromString("7c74af83-8605-45c1-a30b-7a05d5d7f8c1");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("type", type);
        queryParameters.addIfNotEmpty("scheme", scheme);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<ServiceEndpointType>>(){});
    }

    public TaskAgentSession createAgentSession(TaskAgentSession session, int poolId) {
        UUID locationId = UUID.fromString("134e239e-2df3-4794-a6f6-24f1f19ec8dc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, session, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgentSession.class);
    }

    public void deleteAgentSession(int poolId, UUID sessionId) {
        UUID locationId = UUID.fromString("134e239e-2df3-4794-a6f6-24f1f19ec8dc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("sessionId", sessionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public TaskGroup addTaskGroup(TaskGroup taskGroup, String project) {
        UUID locationId = UUID.fromString("6c08ffbf-dbf1-4f9a-94e5-a1cbd47005e7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, taskGroup, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskGroup.class);
    }

    public TaskGroup addTaskGroup(TaskGroup taskGroup, UUID project) {
        UUID locationId = UUID.fromString("6c08ffbf-dbf1-4f9a-94e5-a1cbd47005e7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, taskGroup, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskGroup.class);
    }

    public void deleteTaskGroup(String project, UUID taskGroupId) {
        UUID locationId = UUID.fromString("6c08ffbf-dbf1-4f9a-94e5-a1cbd47005e7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("taskGroupId", taskGroupId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void deleteTaskGroup(UUID project, UUID taskGroupId) {
        UUID locationId = UUID.fromString("6c08ffbf-dbf1-4f9a-94e5-a1cbd47005e7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("taskGroupId", taskGroupId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ArrayList<TaskGroup> getTaskGroups(String project, UUID taskGroupId, Boolean expanded) {
        UUID locationId = UUID.fromString("6c08ffbf-dbf1-4f9a-94e5-a1cbd47005e7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("taskGroupId", taskGroupId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("expanded", expanded);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskGroup>>(){});
    }

    public ArrayList<TaskGroup> getTaskGroups(UUID project, UUID taskGroupId, Boolean expanded) {
        UUID locationId = UUID.fromString("6c08ffbf-dbf1-4f9a-94e5-a1cbd47005e7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        routeValues.put("taskGroupId", taskGroupId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("expanded", expanded);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<TaskGroup>>(){});
    }

    public TaskGroup updateTaskGroup(TaskGroup taskGroup, String project) {
        UUID locationId = UUID.fromString("6c08ffbf-dbf1-4f9a-94e5-a1cbd47005e7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, taskGroup, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskGroup.class);
    }

    public TaskGroup updateTaskGroup(TaskGroup taskGroup, UUID project) {
        UUID locationId = UUID.fromString("6c08ffbf-dbf1-4f9a-94e5-a1cbd47005e7");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("project", project);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, taskGroup, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskGroup.class);
    }

    public void deleteTaskDefinition(UUID taskId) {
        UUID locationId = UUID.fromString("60aac929-f0cd-4bc8-9ce4-6b30e8f1b1bd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("taskId", taskId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public InputStream getTaskContentZip(UUID taskId, String versionString, List<String> visibility, Boolean scopeLocal) {
        UUID locationId = UUID.fromString("60aac929-f0cd-4bc8-9ce4-6b30e8f1b1bd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("taskId", taskId);
        routeValues.put("versionString", versionString);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("visibility", visibility);
        queryParameters.addIfNotNull("scopeLocal", scopeLocal);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/zip");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public TaskDefinition getTaskDefinition(UUID taskId, String versionString, List<String> visibility, Boolean scopeLocal) {
        UUID locationId = UUID.fromString("60aac929-f0cd-4bc8-9ce4-6b30e8f1b1bd");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("taskId", taskId);
        routeValues.put("versionString", versionString);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("visibility", visibility);
        queryParameters.addIfNotNull("scopeLocal", scopeLocal);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, TaskDefinition.class);
    }

    public TaskAgent updateAgentUserCapabilities(Map<String, String> userCapabilities, int poolId, int agentId) {
        UUID locationId = UUID.fromString("30ba3ada-fedf-4da8-bbb5-dacf2f82e176");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("poolId", poolId);
        routeValues.put("agentId", agentId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, userCapabilities, "application/json", "application/json");
        return super.sendRequest(httpRequest, TaskAgent.class);
    }
}

