/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.CheckinFlags;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.MergeFlags;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.QueryMergesExtendedOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ResolveErrorOptions;
import com.microsoft.tfs.core.clients.versioncontrol.RollbackOptions;
import com.microsoft.tfs.core.clients.versioncontrol.SupportedFeatures;
import com.microsoft.tfs.core.clients.versioncontrol.UploadedBaselinesCollection;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ResourceAccessException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.LocalWorkspaceResolvedConflictHandler;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolveErrorHandler;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolvedHandler;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.AllTablesTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalDataAccessLayer;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalPendingChangesTable;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceProperties;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.LocalWorkspaceTransaction;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLocalItem;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceLock;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ArtifactPropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangesetMerge;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangesetMergeDetails;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedMerge;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelChildOption;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalVersion;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.MergeCandidate;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Shelveset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.VersionControlLabel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkspaceItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.CheckinNotificationInfo;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.WorkspaceVersionSpec;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.exceptions.mappers.VersionControlExceptionMapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import com.microsoft.tfs.core.ws.runtime.serialization.ElementDeserializable;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import ms.tfs.versioncontrol.clientservices._03._BranchRelative;
import ms.tfs.versioncontrol.clientservices._03._ChangeRequest;
import ms.tfs.versioncontrol.clientservices._03._ItemSpec;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_PendChangesInLocalWorkspaceResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_QueryPendingSetsWithLocalWorkspacesResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_UndoPendingChangesInLocalWorkspaceResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_PendChangesInLocalWorkspaceResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_QueryPendingSetsWithLocalWorkspacesResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_UndoPendingChangesInLocalWorkspaceResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebServiceLayerLocalWorkspaces
extends WebServiceLayer {
    private static final Log log = LogFactory.getLog(WebServiceLayerLocalWorkspaces.class);
    public static final GUID INITIAL_PENDING_CHANGES_SIGNATURE = new GUID("B2140B25-F70A-4B4D-BFB1-184703037010");

    public WebServiceLayerLocalWorkspaces(VersionControlClient client, _RepositorySoap repository, _RepositoryExtensionsSoap repositoryExtensions, _Repository4Soap repository4, _Repository5Soap repository5) {
        super(client, repository, repositoryExtensions, repository4, repository5);
    }

    protected Workspace getLocalWorkspace(String workspaceName, String ownerName) {
        Workspace localWorkspace = null;
        Workspace workspace = this.getWorkspace(workspaceName, ownerName);
        if (null != workspace && WorkspaceLocation.LOCAL == workspace.getLocation() && workspace.isLocal()) {
            localWorkspace = workspace;
        }
        return localWorkspace;
    }

    protected Workspace reconcileIfLocalItem(String workspaceName, String ownerName, String item, boolean unscannedReconcile) {
        if (item != null && item.length() > 0) {
            return this.reconcileIfAnyLocalItems(workspaceName, ownerName, new String[]{item}, unscannedReconcile);
        }
        return null;
    }

    protected Workspace reconcileIfLocalItem(String workspaceName, String ownerName, String item) {
        if (item != null && item.length() > 0) {
            return this.reconcileIfAnyLocalItems(workspaceName, ownerName, new String[]{item});
        }
        return null;
    }

    protected Workspace reconcileIfLocalItemSpec(String workspaceName, String ownerName, ItemSpec itemSpec, boolean unscannedReconcile) {
        if (null != itemSpec) {
            return this.reconcileIfAnyLocalItemSpecs(workspaceName, ownerName, new ItemSpec[]{itemSpec}, unscannedReconcile);
        }
        return null;
    }

    protected Workspace reconcileIfLocalItemSpec(String workspaceName, String ownerName, ItemSpec itemSpec) {
        if (null != itemSpec) {
            return this.reconcileIfAnyLocalItemSpecs(workspaceName, ownerName, new ItemSpec[]{itemSpec}, false);
        }
        return null;
    }

    protected Workspace reconcileIfAnyLocalItems(String workspaceName, String ownerName, String[] items) {
        return this.reconcileIfAnyLocalItems(workspaceName, ownerName, items, false);
    }

    protected Workspace reconcileIfAnyLocalItems(String workspaceName, String ownerName, String[] items, boolean unscannedReconcile) {
        boolean atLeastOneLocalItem = false;
        if (null != items) {
            for (String item : items) {
                if (null == item || ServerPath.isServerPath(item)) continue;
                atLeastOneLocalItem = true;
                break;
            }
        }
        if (atLeastOneLocalItem) {
            return this.reconcileIfLocal(workspaceName, ownerName, unscannedReconcile, false, false, null);
        }
        return null;
    }

    protected Workspace reconcileIfAnyLocalItemSpecs(String workspaceName, String ownerName, ItemSpec[] itemSpecs) {
        return this.reconcileIfAnyLocalItemSpecs(workspaceName, ownerName, itemSpecs, false);
    }

    protected Workspace reconcileIfAnyLocalItemSpecs(String workspaceName, String ownerName, ItemSpec[] itemSpecs, boolean unscannedReconcile) {
        boolean atLeastOneLocalItemSpec = false;
        if (null != itemSpecs) {
            for (ItemSpec itemSpec : itemSpecs) {
                if (null == itemSpec || null == itemSpec.getItem() || ServerPath.isServerPath(itemSpec.getItem())) continue;
                atLeastOneLocalItemSpec = true;
                break;
            }
        }
        if (atLeastOneLocalItemSpec) {
            return this.reconcileIfLocal(workspaceName, ownerName, unscannedReconcile, false, false, null);
        }
        return null;
    }

    public Workspace reconcileIfLocalVersionSpec(VersionSpec versionSpec) {
        return this.reconcileIfLocalVersionSpec(versionSpec, false);
    }

    public Workspace reconcileIfLocalVersionSpec(VersionSpec versionSpec, boolean unscannedReconcile) {
        if (versionSpec instanceof WorkspaceVersionSpec) {
            WorkspaceVersionSpec workspaceVersionSpec = (WorkspaceVersionSpec)versionSpec;
            return this.reconcileIfLocal(workspaceVersionSpec.getName(), this.getVersionControlClient().resolveUserUniqueName(workspaceVersionSpec.getOwner()), unscannedReconcile, false, false, null);
        }
        return null;
    }

    protected Workspace reconcileIfLocal(String workspaceName, String ownerName) {
        return this.reconcileIfLocal(workspaceName, ownerName, false, false, false, null);
    }

    protected Workspace reconcileIfLocal(String workspaceName, String ownerName, AtomicBoolean reconciled) {
        return this.reconcileIfLocal(workspaceName, ownerName, false, false, false, null);
    }

    protected Workspace reconcileIfLocal(String workspaceName, String ownerName, boolean unscannedReconcile, boolean reconcileMissingLocalItems, boolean skipIfAccessDenied, AtomicBoolean reconciled) {
        if (reconciled != null) {
            reconciled.set(false);
        }
        if (workspaceName == null || workspaceName.length() == 0 || ownerName == null || ownerName.length() == 0) {
            return null;
        }
        Workspace localWorkspace = null;
        localWorkspace = this.getLocalWorkspace(workspaceName, ownerName);
        if (localWorkspace != null) {
            AtomicReference<Failure[]> failures = new AtomicReference<Failure[]>();
            AtomicBoolean pendingChangesUpdatedByServer = new AtomicBoolean();
            try {
                boolean wasReconciled = LocalDataAccessLayer.reconcileLocalWorkspace(localWorkspace, this, unscannedReconcile, reconcileMissingLocalItems, failures, pendingChangesUpdatedByServer);
                if (wasReconciled) {
                    localWorkspace.invalidateMappings();
                    localWorkspace.refreshMappingsIfNeeded();
                }
                if (reconciled != null) {
                    reconciled.set(wasReconciled);
                }
            }
            catch (ResourceAccessException e) {
                if (!skipIfAccessDenied) {
                    throw e;
                }
                return null;
            }
            this.getVersionControlClient().reportFailures(localWorkspace, failures.get());
        }
        return localWorkspace;
    }

    protected void syncPendingChangesIfLocal(Workspace workspace, String[] itemPropertyFilters) {
        this.syncPendingChangesIfLocal(workspace, new GetOperation[0], itemPropertyFilters);
    }

    protected void syncPendingChangesIfLocal(Workspace workspace, GetOperation[] getOperations, String[] itemPropertyFilters) {
        if (workspace != null && workspace.getLocation() == WorkspaceLocation.LOCAL) {
            LocalDataAccessLayer.syncPendingChanges(workspace, getOperations, itemPropertyFilters);
        }
    }

    protected WorkspaceLock lockIfLocal(Workspace workspace) {
        if (null != workspace) {
            try {
                return workspace.lock();
            }
            catch (Exception e) {
                throw new VersionControlException(e.getLocalizedMessage());
            }
        }
        return null;
    }

    @Override
    public PendingChange[] queryServerPendingChanges(Workspace localWorkspace, AtomicReference<GUID> outServerPendingChangeSignature) {
        Failure[] failures;
        PendingSet[] pendingSets;
        Check.isTrue(WorkspaceLocation.LOCAL == localWorkspace.getLocation(), "WorkspaceLocation.LOCAL == localWorkspace.getLocation()");
        Object[] itemSpecs = new ItemSpec[]{new ItemSpec("$/", RecursionType.FULL)};
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_QueryPendingSetsWithLocalWorkspacesResponse response = this.getRepository5().queryPendingSetsWithLocalWorkspaces(null, null, localWorkspace.getName(), localWorkspace.getOwnerName(), (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), false, null, 399);
                pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, response.getQueryPendingSetsWithLocalWorkspacesResult());
                failures = (Failure[])WrapperUtils.wrap(Failure.class, response.getFailures());
            } else {
                _Repository4Soap_QueryPendingSetsWithLocalWorkspacesResponse response = this.getRepository4().queryPendingSetsWithLocalWorkspaces(null, null, localWorkspace.getName(), localWorkspace.getOwnerName(), (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), false, null);
                pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, response.getQueryPendingSetsWithLocalWorkspacesResult());
                failures = (Failure[])WrapperUtils.wrap(Failure.class, response.getFailures());
            }
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        this.getVersionControlClient().reportFailures(localWorkspace, failures);
        if (pendingSets.length == 0) {
            outServerPendingChangeSignature.set(this.queryPendingChangeSignature(localWorkspace.getName(), localWorkspace.getOwnerName()));
            return new PendingChange[0];
        }
        outServerPendingChangeSignature.set(pendingSets[0].getPendingChangeSignature());
        if (outServerPendingChangeSignature.get().equals(GUID.EMPTY)) {
            outServerPendingChangeSignature.set(this.queryPendingChangeSignature(localWorkspace.getName(), localWorkspace.getOwnerName()));
        }
        return pendingSets[0].getPendingChanges();
    }

    @Override
    public PendingChange[] queryServerPendingChanges(Workspace workspace, ItemSpec[] itemSpecs, boolean generateDownloadUrls, String[] itemPropertyFilters) {
        Failure[] failures;
        PendingSet[] pendingSets;
        if (workspace.getLocation().equals(WorkspaceLocation.LOCAL)) {
            _Repository4Soap_QueryPendingSetsWithLocalWorkspacesResponse response;
            try {
                response = this.getRepository4().queryPendingSetsWithLocalWorkspaces(null, null, workspace.getName(), workspace.getOwnerName(), (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls, null);
            }
            catch (ProxyException e) {
                throw VersionControlExceptionMapper.map(e);
            }
            pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, response.getQueryPendingSetsWithLocalWorkspacesResult());
            failures = (Failure[])WrapperUtils.wrap(Failure.class, response.getFailures());
        } else {
            AtomicReference<Failure[]> failuresHolder = new AtomicReference<Failure[]>();
            pendingSets = super.queryPendingSets(null, null, workspace.getName(), workspace.getOwnerName(), itemSpecs, generateDownloadUrls, failuresHolder, false, null);
            failures = failuresHolder.get();
        }
        this.getVersionControlClient().reportFailures(workspace, failures);
        if (pendingSets.length == 0) {
            return new PendingChange[0];
        }
        return pendingSets[0].getPendingChanges();
    }

    public void syncWorkingFoldersIfNecessary(Workspace localWorkspace, ChangePendedFlags flags) {
        Workspace serverUpdatedWorkspace;
        if (null != localWorkspace && flags.contains(ChangePendedFlags.WORKING_FOLDER_MAPPINGS_UPDATED) && null != (serverUpdatedWorkspace = super.queryWorkspace(localWorkspace.getName(), localWorkspace.getOwnerName()))) {
            LocalDataAccessLayer.setWorkingFolders(localWorkspace, serverUpdatedWorkspace.getFolders());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConflict(String workspaceName, String ownerName, ConflictType conflictType, int itemId, int versionFrom, int pendingChangeId, String sourceLocalItem, String targetLocalItem, OperationStatus reason, String[] itemPropertyFilters) {
        Workspace w = this.reconcileIfLocal(workspaceName, ownerName);
        WorkspaceLock lock = this.lockIfLocal(w);
        try {
            super.addConflict(workspaceName, ownerName, conflictType, itemId, versionFrom, pendingChangeId, sourceLocalItem, targetLocalItem, reason, itemPropertyFilters);
            if (conflictType == ConflictType.MERGE) {
                this.syncPendingChangesIfLocal(w, itemPropertyFilters);
            }
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckinResult checkIn(String workspaceName, String ownerName, String[] serverItems, Changeset info, CheckinNotificationInfo checkinNotificationInfo, CheckinFlags checkinOptions, UploadedBaselinesCollection uploadedBaselinesCollection, AtomicReference<Failure[]> conflicts, AtomicReference<Failure[]> failures, boolean deferCheckIn, int checkInTicket, String[] itemPropertyFilters) {
        Workspace w = this.reconcileIfLocal(workspaceName, ownerName, true, false, false, null);
        WorkspaceLock lock = this.lockIfLocal(w);
        try {
            CheckinResult toReturn = super.checkIn(workspaceName, ownerName, serverItems, info, checkinNotificationInfo, checkinOptions, uploadedBaselinesCollection, conflicts, failures, deferCheckIn, checkInTicket, itemPropertyFilters);
            if (w != null && w.getLocation() == WorkspaceLocation.LOCAL) {
                if (toReturn.getChangeset() > 0) {
                    LocalDataAccessLayer.afterCheckin(w, toReturn.getChangeset(), toReturn.getDate(), toReturn.getLocalVersionUpdates(), this.queryServerPendingChanges(w, itemPropertyFilters), uploadedBaselinesCollection);
                } else if (0 == toReturn.getChangeset()) {
                    this.syncPendingChangesIfLocal(w, itemPropertyFilters);
                }
            }
            CheckinResult checkinResult = toReturn;
            return checkinResult;
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    @Override
    public Failure[] checkPendingChanges(String workspaceName, String ownerName, String[] serverItems) {
        this.reconcileIfLocal(workspaceName, ownerName);
        return super.checkPendingChanges(workspaceName, ownerName, serverItems);
    }

    @Override
    public GetOperation[][] get(String workspaceName, String ownerName, GetRequest[] requests, int maxResults, GetOptions options, String[] itemAttributeFilters, String[] itemPropertyFilters, boolean noGet) {
        Workspace localWorkspace = this.getLocalWorkspace(workspaceName, ownerName);
        if (localWorkspace != null) {
            boolean reconcileMissingLocalItems = false;
            for (GetRequest getRequest : requests) {
                VersionSpec versionSpec;
                if (null == getRequest || null != (versionSpec = getRequest.getVersionSpec()) && (!(versionSpec instanceof WorkspaceVersionSpec) || Workspace.matchName(localWorkspace.getName(), ((WorkspaceVersionSpec)versionSpec).getName()) && localWorkspace.ownerNameMatches(((WorkspaceVersionSpec)versionSpec).getOwner()))) continue;
                reconcileMissingLocalItems = true;
                break;
            }
            AtomicBoolean reconciled = new AtomicBoolean();
            this.reconcileIfLocal(workspaceName, ownerName, false, reconcileMissingLocalItems, false, reconciled);
            if (localWorkspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN)) {
                LocalDataAccessLayer.snapBackToCheckinDate(localWorkspace, requests);
            }
        }
        GetOperation[][] result = super.get(workspaceName, ownerName, requests, maxResults, options, itemAttributeFilters, itemPropertyFilters, noGet);
        return result;
    }

    @Override
    public LabelResult[] labelItem(String workspaceName, String workspaceOwner, VersionControlLabel label, LabelItemSpec[] labelSpecs, LabelChildOption children, AtomicReference<Failure[]> failures) {
        ArrayList<ItemSpec> itemSpecs = new ArrayList<ItemSpec>();
        if (null != labelSpecs) {
            for (LabelItemSpec labelItemSpec : labelSpecs) {
                if (null == labelItemSpec) continue;
                itemSpecs.add(labelItemSpec.getItemSpec());
                this.reconcileIfLocalVersionSpec(labelItemSpec.getVersion(), true);
            }
        }
        if (itemSpecs.size() > 0) {
            this.reconcileIfAnyLocalItemSpecs(workspaceName, workspaceOwner, itemSpecs.toArray(new ItemSpec[itemSpecs.size()]), true);
        }
        return super.labelItem(workspaceName, workspaceOwner, label, labelSpecs, children, failures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperation[] merge(String workspaceName, String workspaceOwner, ItemSpec source, ItemSpec target, VersionSpec from, VersionSpec to, LockLevel lockLevel, MergeFlags mergeFlags, AtomicReference<Failure[]> failures, AtomicReference<Conflict[]> conflicts, String[] itemAttributeFilters, String[] itemPropertyFilters, AtomicReference<ChangePendedFlags> changePendedFlags) {
        Workspace w = this.reconcileIfLocal(workspaceName, workspaceOwner);
        this.reconcileIfLocalVersionSpec(from, true);
        this.reconcileIfLocalVersionSpec(to, true);
        WorkspaceLock lock = this.lockIfLocal(w);
        try {
            GetOperation[] toReturn = super.merge(workspaceName, workspaceOwner, source, target, from, to, lockLevel, mergeFlags, failures, conflicts, itemAttributeFilters, itemPropertyFilters, changePendedFlags);
            this.syncWorkingFoldersIfNecessary(w, changePendedFlags.get());
            this.syncPendingChangesIfLocal(w, toReturn, itemPropertyFilters);
            GetOperation[] getOperationArray = toReturn;
            return getOperationArray;
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    public GetOperation[] pendChangesInLocalWorkspace(String workspaceName, String ownerName, ChangeRequest[] changes, PendChangesOptions pendChangesOptions, SupportedFeatures supportedFeatures, AtomicReference<Failure[]> failures, String[] itemPropertyFilters, String[] itemAttributeFilters, AtomicBoolean onlineOperation, AtomicReference<ChangePendedFlags> changePendedFlags) {
        _Repository4Soap_PendChangesInLocalWorkspaceResponse response;
        try {
            response = this.getRepository4().pendChangesInLocalWorkspace(workspaceName, ownerName, (_ChangeRequest[])WrapperUtils.unwrap(_ChangeRequest.class, changes), pendChangesOptions.toIntFlags(), supportedFeatures.toIntFlags(), itemPropertyFilters, itemAttributeFilters);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        GetOperation[] toReturn = (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getPendChangesInLocalWorkspaceResult());
        failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
        changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
        onlineOperation.set(true);
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperation[] pendChanges(String workspaceName, String ownerName, final ChangeRequest[] changes, PendChangesOptions pendChangesOptions, SupportedFeatures supportedFeatures, AtomicReference<Failure[]> failures, final String[] itemPropertyFilters, String[] itemAttributeFilters, final boolean updateDisk, AtomicBoolean onlineOperation, AtomicReference<ChangePendedFlags> changePendedFlags) {
        Workspace localWorkspace;
        int unlockCount;
        block32: {
            onlineOperation.set(false);
            changePendedFlags.set(ChangePendedFlags.NONE);
            unlockCount = 0;
            localWorkspace = this.getLocalWorkspace(workspaceName, ownerName);
            if (localWorkspace != null) {
                boolean attributeChange = false;
                boolean nonExecuteSymlinkBitPropertyChange = false;
                if (null != itemAttributeFilters && itemAttributeFilters.length > 0) {
                    attributeChange = true;
                }
                if (null != itemPropertyFilters && itemPropertyFilters.length > 0) {
                    for (String filter : itemPropertyFilters) {
                        if (PropertyValue.comparePropertyNames("Microsoft.TeamFoundation.VersionControl.Executable", filter) == 0 || PropertyValue.comparePropertyNames("Microsoft.TeamFoundation.VersionControl.SymbolicLink", filter) == 0) continue;
                        nonExecuteSymlinkBitPropertyChange = true;
                        break;
                    }
                }
                RequestType requestType = RequestType.NONE;
                boolean requestingLock = false;
                for (ChangeRequest changeRequest : changes) {
                    if (RequestType.NONE == requestType) {
                        requestType = changeRequest.getRequestType();
                    } else if (requestType != changeRequest.getRequestType()) {
                        throw new VersionControlException("Not all changes had the same request type");
                    }
                    if (changeRequest.getLockLevel() != LockLevel.UNCHANGED && (changeRequest.getLockLevel() != LockLevel.NONE || changeRequest.getRequestType() != RequestType.ADD)) {
                        requestingLock = true;
                    }
                    if (changeRequest.getLockLevel() != LockLevel.NONE || !changeRequest.getRequestType().equals(RequestType.LOCK)) continue;
                    ++unlockCount;
                }
                final boolean silent = pendChangesOptions.contains(PendChangesOptions.SILENT);
                if (!(requestingLock || attributeChange || nonExecuteSymlinkBitPropertyChange)) {
                    if (requestType == RequestType.ADD || requestType == RequestType.EDIT || requestType == RequestType.DELETE || requestType == RequestType.RENAME || requestType == RequestType.PROPERTY) {
                        final LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(localWorkspace);
                        try {
                            final AtomicReference delegateFailures = new AtomicReference();
                            final AtomicReference toReturn = new AtomicReference();
                            final RequestType transactionRequestType = requestType;
                            transaction.execute(new AllTablesTransaction(){

                                @Override
                                public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                                    AtomicBoolean onlineOperationRequired;
                                    if (transactionRequestType == RequestType.ADD) {
                                        toReturn.set(LocalDataAccessLayer.pendAdd(localWorkspace, wp, lv, pc, changes, silent, delegateFailures, itemPropertyFilters));
                                    } else if (transactionRequestType == RequestType.EDIT) {
                                        toReturn.set(LocalDataAccessLayer.pendEdit(localWorkspace, wp, lv, pc, changes, silent, delegateFailures, itemPropertyFilters));
                                    } else if (transactionRequestType == RequestType.DELETE) {
                                        toReturn.set(LocalDataAccessLayer.pendDelete(localWorkspace, wp, lv, pc, changes, silent, delegateFailures, itemPropertyFilters));
                                    } else if (transactionRequestType == RequestType.RENAME) {
                                        onlineOperationRequired = new AtomicBoolean(false);
                                        toReturn.set(LocalDataAccessLayer.pendRename(localWorkspace, wp, lv, pc, changes, silent, delegateFailures, onlineOperationRequired, itemPropertyFilters));
                                        if (onlineOperationRequired.get()) {
                                            toReturn.set(null);
                                            transaction.abort();
                                        } else if (updateDisk) {
                                            for (GetOperation getOp : (GetOperation[])toReturn.get()) {
                                                if (getOp.getTargetLocalItem() == null || LocalPath.equals(getOp.getSourceLocalItem(), getOp.getTargetLocalItem()) || !new File(getOp.getTargetLocalItem()).exists()) continue;
                                                throw new VersionControlException(MessageFormat.format(Messages.getString("WebServiceLayerLocalWorkspaces.FileExistsFormat"), getOp.getTargetLocalItem()));
                                            }
                                        }
                                    }
                                    if (transactionRequestType == RequestType.PROPERTY) {
                                        onlineOperationRequired = new AtomicBoolean(false);
                                        toReturn.set(LocalDataAccessLayer.pendPropertyChange(localWorkspace, wp, lv, pc, changes, silent, delegateFailures, onlineOperationRequired, itemPropertyFilters));
                                        if (onlineOperationRequired.get()) {
                                            toReturn.set(null);
                                            transaction.abort();
                                        }
                                    }
                                }
                            });
                            if (toReturn.get() != null) {
                                failures.set((Failure[])delegateFailures.get());
                                GetOperation[] getOperationArray = (GetOperation[])toReturn.get();
                                return getOperationArray;
                            }
                            break block32;
                        }
                        finally {
                            try {
                                transaction.close();
                            }
                            catch (IOException e) {
                                throw new VersionControlException(e);
                            }
                        }
                    }
                    if (requestType != RequestType.BRANCH && requestType != RequestType.UNDELETE && requestType != RequestType.LOCK) {
                        throw new VersionControlException("Not currently implemented for local workspaces");
                    }
                }
            }
        }
        if (null != localWorkspace) {
            Workspace w = this.reconcileIfLocal(workspaceName, ownerName, false, false, unlockCount == changes.length, null);
            WorkspaceLock lock = this.lockIfLocal(w);
            try {
                GetOperation[] toReturn;
                try {
                    ElementDeserializable response;
                    if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                        response = this.getRepository5().pendChangesInLocalWorkspace(workspaceName, ownerName, (_ChangeRequest[])WrapperUtils.unwrap(_ChangeRequest.class, changes), pendChangesOptions.toIntFlags(), supportedFeatures.toIntFlags(), itemPropertyFilters, itemAttributeFilters, 399);
                        toReturn = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_Repository5Soap_PendChangesInLocalWorkspaceResponse)response).getPendChangesInLocalWorkspaceResult());
                        failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository5Soap_PendChangesInLocalWorkspaceResponse)response).getFailures()));
                        changePendedFlags.set(new ChangePendedFlags(((_Repository5Soap_PendChangesInLocalWorkspaceResponse)response).getChangePendedFlags()));
                    } else {
                        response = this.getRepository4().pendChangesInLocalWorkspace(workspaceName, ownerName, (_ChangeRequest[])WrapperUtils.unwrap(_ChangeRequest.class, changes), pendChangesOptions.toIntFlags(), supportedFeatures.toIntFlags(), itemPropertyFilters, itemAttributeFilters);
                        toReturn = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_Repository4Soap_PendChangesInLocalWorkspaceResponse)response).getPendChangesInLocalWorkspaceResult());
                        failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository4Soap_PendChangesInLocalWorkspaceResponse)response).getFailures()));
                        changePendedFlags.set(new ChangePendedFlags(((_Repository4Soap_PendChangesInLocalWorkspaceResponse)response).getChangePendedFlags()));
                    }
                }
                catch (ProxyException e) {
                    throw VersionControlExceptionMapper.map(e);
                }
                this.syncWorkingFoldersIfNecessary(w, changePendedFlags.get());
                this.syncPendingChangesIfLocal(w, toReturn, itemPropertyFilters);
                if (RequestType.ADD == changes[0].getRequestType()) {
                    LocalDataAccessLayer.afterAdd(localWorkspace, toReturn);
                    localWorkspace.getWorkspaceWatcher().markPathChanged("");
                }
                onlineOperation.set(true);
                GetOperation[] getOperationArray = toReturn;
                return getOperationArray;
            }
            finally {
                if (lock != null) {
                    lock.close();
                }
            }
        }
        return super.pendChanges(workspaceName, ownerName, changes, pendChangesOptions, supportedFeatures, failures, itemPropertyFilters, itemAttributeFilters, updateDisk, onlineOperation, changePendedFlags);
    }

    @Override
    public _BranchRelative[][] queryBranches(String workspaceName, String workspaceOwner, ItemSpec[] items, VersionSpec version) {
        this.reconcileIfAnyLocalItemSpecs(workspaceName, workspaceOwner, items, true);
        this.reconcileIfLocalVersionSpec(version, true);
        return super.queryBranches(workspaceName, workspaceOwner, items, version);
    }

    @Override
    public Conflict[] queryConflicts(String workspaceName, String ownerName, ItemSpec[] items) {
        this.reconcileIfLocal(workspaceName, ownerName);
        return super.queryConflicts(workspaceName, ownerName, items);
    }

    @Override
    public String[] queryEffectiveItemPermissions(String workspaceName, String workspaceOwner, String item, String identityName) {
        this.reconcileIfLocalItem(workspaceName, workspaceOwner, item, true);
        return super.queryEffectiveItemPermissions(workspaceName, workspaceOwner, item, identityName);
    }

    @Override
    public Changeset[] queryHistory(String workspaceName, String workspaceOwner, ItemSpec itemSpec, VersionSpec versionItem, String user, VersionSpec versionFrom, VersionSpec versionTo, int maxCount, boolean includeFiles, boolean generateDownloadUrls, boolean slotMode, boolean sortAscending) {
        this.reconcileIfLocalItemSpec(workspaceName, workspaceOwner, itemSpec, true);
        this.reconcileIfLocalVersionSpec(versionItem, true);
        this.reconcileIfLocalVersionSpec(versionFrom, true);
        this.reconcileIfLocalVersionSpec(versionTo, true);
        return super.queryHistory(workspaceName, workspaceOwner, itemSpec, versionItem, user, versionFrom, versionTo, maxCount, includeFiles, generateDownloadUrls, slotMode, sortAscending);
    }

    @Override
    public ItemSet[] queryItems(String workspaceName, String workspaceOwner, ItemSpec[] items, VersionSpec version, DeletedState deletedState, ItemType itemType, boolean generateDownloadUrls, GetItemsOptions options, String[] itemPropertyFilters, String[] itemAttributeFilters) {
        this.reconcileIfAnyLocalItemSpecs(workspaceName, workspaceOwner, items, true);
        this.reconcileIfLocalVersionSpec(version, true);
        return super.queryItems(workspaceName, workspaceOwner, items, version, deletedState, itemType, generateDownloadUrls, options, itemPropertyFilters, itemAttributeFilters);
    }

    @Override
    public ExtendedItem[][] queryItemsExtended(String workspaceName, String workspaceOwner, ItemSpec[] items, DeletedState deletedState, ItemType itemType, GetItemsOptions options, String[] itemPropertyFilters) {
        Workspace localWorkspace;
        boolean includeLocalOnly = options.contains(GetItemsOptions.LOCAL_ONLY);
        if (includeLocalOnly && workspaceName != null && workspaceName.length() > 0 && workspaceOwner != null && workspaceOwner.length() > 0 && (localWorkspace = this.getLocalWorkspace(workspaceName, workspaceOwner)) != null) {
            return LocalDataAccessLayer.queryItemsExtended(localWorkspace, items, deletedState, itemType, options);
        }
        this.reconcileIfLocal(workspaceName, workspaceOwner);
        ExtendedItem[][] result = super.queryItemsExtended(workspaceName, workspaceOwner, items, deletedState, itemType, options, itemPropertyFilters);
        if (includeLocalOnly) {
            result = this.removeNonLocalExtendedItems(result);
        }
        return result;
    }

    private ExtendedItem[][] removeNonLocalExtendedItems(ExtendedItem[][] extendedItems) {
        ExtendedItem[][] result = new ExtendedItem[extendedItems.length][];
        for (int i = 0; i < extendedItems.length; ++i) {
            ExtendedItem[] items = extendedItems[i];
            int nonLocalNumber = 0;
            for (int j = 0; j < items.length; ++j) {
                if (!this.isNonLocal(items[j])) continue;
                ++nonLocalNumber;
            }
            if (nonLocalNumber == 0) {
                result[i] = items;
                continue;
            }
            result[i] = new ExtendedItem[items.length - nonLocalNumber];
            int newIndex = 0;
            for (int originalIndex = 0; originalIndex < items.length && newIndex < result[i].length; ++originalIndex) {
                if (this.isNonLocal(items[originalIndex])) continue;
                result[i][newIndex] = items[originalIndex];
                ++newIndex;
            }
            Check.isTrue(result[i].length == 0 || result[i][result[i].length - 1] != null, "We didn't fill full result array with extendedItems - caller can fail with Nullrefs");
        }
        return result;
    }

    private boolean isNonLocal(ExtendedItem item) {
        return item.getLocalItem() == null && !item.getPendingChange().contains(ChangeType.DELETE);
    }

    @Override
    public VersionControlLabel[] queryLabels(String workspaceName, String workspaceOwner, String labelName, String labelScope, String owner, String filterItem, VersionSpec versionFilterItem, boolean includeItems, boolean generateDownloadUrls) {
        this.reconcileIfLocalItem(workspaceName, workspaceOwner, filterItem, true);
        this.reconcileIfLocalVersionSpec(versionFilterItem, true);
        return super.queryLabels(workspaceName, workspaceOwner, labelName, labelScope, owner, filterItem, versionFilterItem, includeItems, generateDownloadUrls);
    }

    @Override
    public LocalVersion[][] queryLocalVersions(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs) {
        Workspace localWorkspace = this.getLocalWorkspace(workspaceName, workspaceOwner);
        if (localWorkspace != null) {
            return LocalDataAccessLayer.queryLocalVersions(localWorkspace, itemSpecs);
        }
        return super.queryLocalVersions(workspaceName, workspaceOwner, itemSpecs);
    }

    @Override
    public MergeCandidate[] queryMergeCandidates(String workspaceName, String workspaceOwner, ItemSpec source, ItemSpec target, MergeFlags mergeFlags) {
        this.reconcileIfLocalItemSpec(workspaceName, workspaceOwner, source, true);
        this.reconcileIfLocalItemSpec(workspaceName, workspaceOwner, target, true);
        return super.queryMergeCandidates(workspaceName, workspaceOwner, source, target, mergeFlags);
    }

    @Override
    public ChangesetMerge[] queryMerges(String workspaceName, String workspaceOwner, ItemSpec source, VersionSpec versionSource, ItemSpec target, VersionSpec versionTarget, VersionSpec versionFrom, VersionSpec versionTo, int maxChangesets, boolean showAll, AtomicReference<Changeset[]> changesets) {
        this.reconcileIfLocalItemSpec(workspaceName, workspaceOwner, source, true);
        this.reconcileIfLocalItemSpec(workspaceName, workspaceOwner, target, true);
        this.reconcileIfLocalVersionSpec(versionSource, true);
        this.reconcileIfLocalVersionSpec(versionTarget, true);
        this.reconcileIfLocalVersionSpec(versionFrom, true);
        this.reconcileIfLocalVersionSpec(versionTo, true);
        return super.queryMerges(workspaceName, workspaceOwner, source, versionSource, target, versionTarget, versionFrom, versionTo, maxChangesets, showAll, changesets);
    }

    @Override
    public ExtendedMerge[] queryMergesExtended(String workspaceName, String workspaceOwner, ItemSpec target, VersionSpec versionTarget, VersionSpec versionFrom, VersionSpec versionTo, QueryMergesExtendedOptions options) {
        this.reconcileIfLocalItemSpec(workspaceName, workspaceOwner, target, true);
        this.reconcileIfLocalVersionSpec(versionTarget, true);
        this.reconcileIfLocalVersionSpec(versionFrom, true);
        this.reconcileIfLocalVersionSpec(versionTo, true);
        return super.queryMergesExtended(workspaceName, workspaceOwner, target, versionTarget, versionFrom, versionTo, options);
    }

    @Override
    public ChangesetMergeDetails queryMergesWithDetails(String workspaceName, String workspaceOwner, ItemSpec source, VersionSpec versionSource, ItemSpec target, VersionSpec versionTarget, VersionSpec versionFrom, VersionSpec versionTo, int maxChangesets, boolean showAll) {
        this.reconcileIfLocalItemSpec(workspaceName, workspaceOwner, source, true);
        this.reconcileIfLocalItemSpec(workspaceName, workspaceOwner, target, true);
        this.reconcileIfLocalVersionSpec(versionSource, true);
        this.reconcileIfLocalVersionSpec(versionTarget, true);
        this.reconcileIfLocalVersionSpec(versionFrom, true);
        this.reconcileIfLocalVersionSpec(versionTo, true);
        return super.queryMergesWithDetails(workspaceName, workspaceOwner, source, versionSource, target, versionTarget, versionFrom, versionTo, maxChangesets, showAll);
    }

    @Override
    public PendingChange[] queryPendingChangesForWorkspace(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs, boolean generateDownloadUrls, int pageSize, String lastChange, boolean includeMergeInfo, AtomicReference<Failure[]> failures, String[] itemPropertyFilters) {
        Workspace localWorkspace;
        if ((itemPropertyFilters == null || itemPropertyFilters.length == 0) && (localWorkspace = this.getLocalWorkspace(workspaceName, workspaceOwner)) != null) {
            boolean okayToPerformLocalQuery = true;
            if (itemSpecs != null && itemSpecs.length > 1) {
                okayToPerformLocalQuery = false;
            }
            if (includeMergeInfo) {
                okayToPerformLocalQuery = false;
            }
            if (generateDownloadUrls) {
                okayToPerformLocalQuery = false;
            }
            if (okayToPerformLocalQuery) {
                ItemSpec[] itemSpecArray;
                if (itemSpecs != null) {
                    itemSpecArray = itemSpecs;
                } else {
                    ItemSpec[] itemSpecArray2 = new ItemSpec[1];
                    itemSpecArray = itemSpecArray2;
                    itemSpecArray2[0] = new ItemSpec("$/", RecursionType.FULL);
                }
                PendingSet[] pendingSets = LocalDataAccessLayer.queryPendingChanges(localWorkspace, itemSpecArray, failures, false, lastChange, pageSize, itemPropertyFilters);
                if (0 == pendingSets.length) {
                    return new PendingChange[0];
                }
                return pendingSets[0].getPendingChanges();
            }
        }
        return super.queryPendingChangesForWorkspace(workspaceName, workspaceOwner, itemSpecs, generateDownloadUrls, pageSize, lastChange, includeMergeInfo, failures, itemPropertyFilters);
    }

    @Override
    public PendingSet[] queryPendingSets(String localWorkspaceName, String localWorkspaceOwner, String queryWorkspaceName, String ownerName, ItemSpec[] itemSpecs, boolean generateDownloadUrls, AtomicReference<Failure[]> failures, boolean includeCandidates, String[] itemPropertyFilters) {
        Workspace localWorkspace = this.getLocalWorkspace(queryWorkspaceName, ownerName);
        if (localWorkspace != null) {
            PendingSet[] pendingSets;
            boolean nonExecuteSymlinkBitPropertyChange = false;
            if (itemPropertyFilters != null) {
                for (String filter : itemPropertyFilters) {
                    if (PropertyValue.comparePropertyNames("Microsoft.TeamFoundation.VersionControl.Executable", filter) == 0 || PropertyValue.comparePropertyNames("Microsoft.TeamFoundation.VersionControl.SymbolicLink", filter) == 0) continue;
                    nonExecuteSymlinkBitPropertyChange = true;
                    break;
                }
            }
            boolean okayToPerformLocalQuery = true;
            if (null != localWorkspaceName && null != localWorkspaceOwner && (!Workspace.matchName(localWorkspaceName, queryWorkspaceName) || !localWorkspace.ownerNameMatches(localWorkspaceOwner)) || nonExecuteSymlinkBitPropertyChange) {
                okayToPerformLocalQuery = false;
            }
            if (okayToPerformLocalQuery) {
                pendingSets = LocalDataAccessLayer.queryPendingChanges(localWorkspace, itemSpecs, failures, includeCandidates, null, 0, itemPropertyFilters);
            } else {
                this.reconcileIfLocal(queryWorkspaceName, ownerName);
                this.reconcileIfAnyLocalItemSpecs(localWorkspaceName, localWorkspaceOwner, itemSpecs);
                try {
                    ElementDeserializable response;
                    if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                        response = this.getRepository5().queryPendingSetsWithLocalWorkspaces(localWorkspaceName, localWorkspaceOwner, queryWorkspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls, itemPropertyFilters, 399);
                        failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository5Soap_QueryPendingSetsWithLocalWorkspacesResponse)response).getFailures()));
                        pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, ((_Repository5Soap_QueryPendingSetsWithLocalWorkspacesResponse)response).getQueryPendingSetsWithLocalWorkspacesResult());
                    } else {
                        response = this.getRepository4().queryPendingSetsWithLocalWorkspaces(localWorkspaceName, localWorkspaceOwner, queryWorkspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls, itemPropertyFilters);
                        failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository4Soap_QueryPendingSetsWithLocalWorkspacesResponse)response).getFailures()));
                        pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, ((_Repository4Soap_QueryPendingSetsWithLocalWorkspacesResponse)response).getQueryPendingSetsWithLocalWorkspacesResult());
                    }
                }
                catch (ProxyException e) {
                    throw VersionControlExceptionMapper.map(e);
                }
            }
            for (PendingSet ps : pendingSets) {
                ps.setPendingSetDetails();
            }
            return pendingSets;
        }
        return super.queryPendingSets(localWorkspaceName, localWorkspaceOwner, queryWorkspaceName, ownerName, itemSpecs, generateDownloadUrls, failures, includeCandidates, itemPropertyFilters);
    }

    @Override
    public PendingSet[] queryShelvedChanges(String localWorkspaceName, String localWorkspaceOwner, String shelvesetName, String ownerName, ItemSpec[] itemSpecs, boolean generateDownloadUrls, AtomicReference<Failure[]> failures, String[] itemPropertyFilters) {
        this.reconcileIfAnyLocalItemSpecs(localWorkspaceName, localWorkspaceOwner, itemSpecs, true);
        return super.queryShelvedChanges(localWorkspaceName, localWorkspaceOwner, shelvesetName, ownerName, itemSpecs, generateDownloadUrls, failures, itemPropertyFilters);
    }

    @Override
    public Workspace queryServerWorkspace(String workspaceName, String ownerName) {
        return super.queryWorkspace(workspaceName, ownerName);
    }

    @Override
    public Workspace queryWorkspace(String workspaceName, String ownerName) {
        Workspace localWorkspace = this.getLocalWorkspace(workspaceName, ownerName);
        if (localWorkspace != null) {
            WorkingFolder[] authoritativeMappings = LocalDataAccessLayer.queryWorkingFolders(localWorkspace);
            Workspace toReturn = super.queryWorkspace(workspaceName, ownerName);
            if (!WorkingFolder.areSetsEqual(toReturn.getFolders(), authoritativeMappings)) {
                toReturn.setFolders(authoritativeMappings);
                toReturn = super.updateWorkspace(workspaceName, ownerName, toReturn, SupportedFeatures.ALL);
            }
            return toReturn;
        }
        return super.queryWorkspace(workspaceName, ownerName);
    }

    @Override
    public WorkspaceItemSet[] queryWorkspaceItems(String workspaceName, String workspaceOwner, ItemSpec[] items, DeletedState deletedState, ItemType itemType, boolean generateDownloadUrls, int options) {
        this.reconcileIfLocal(workspaceName, workspaceOwner);
        return super.queryWorkspaceItems(workspaceName, workspaceOwner, items, deletedState, itemType, generateDownloadUrls, options);
    }

    @Override
    public void removeLocalConflicts(String workspaceName, String ownerName, List<Conflict> conflicts, ResolveErrorOptions errorOptions, ConflictResolvedHandler onResolvedConflict, ConflictResolveErrorHandler onResolveError) throws CoreCancelException {
        this.reconcileIfLocal(workspaceName, ownerName);
        super.removeLocalConflicts(workspaceName, ownerName, conflicts, errorOptions, onResolvedConflict, onResolveError);
    }

    @Override
    public void resolve(String workspaceName, String ownerName, Conflict[] conflicts, String[] itemAttributeFilters, String[] itemPropertyFilters, ResolveErrorOptions errorOptions, ConflictResolvedHandler onResolvedConflict, ConflictResolveErrorHandler onResolveError) throws CoreCancelException {
        Workspace w = this.reconcileIfLocal(workspaceName, ownerName);
        LocalWorkspaceResolvedConflictHandler localHandler = new LocalWorkspaceResolvedConflictHandler(onResolvedConflict);
        super.resolve(workspaceName, ownerName, conflicts, itemAttributeFilters, itemPropertyFilters, errorOptions, localHandler, onResolveError);
        this.syncWorkingFoldersIfNecessary(w, localHandler.getFlags());
        this.syncPendingChangesIfLocal(w, localHandler.getAllOperations(), itemPropertyFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperation[] rollback(String workspaceName, String workspaceOwner, ItemSpec[] items, VersionSpec itemVersion, VersionSpec from, VersionSpec to, RollbackOptions rollbackOptions, LockLevel lockLevel, AtomicReference<Conflict[]> conflicts, AtomicReference<Failure[]> failures, String[] itemAttributeFilters, String[] itemPropertyFilters, AtomicReference<ChangePendedFlags> changePendedFlags) {
        Workspace w = this.reconcileIfLocal(workspaceName, workspaceOwner);
        this.reconcileIfLocalVersionSpec(itemVersion, true);
        this.reconcileIfLocalVersionSpec(from, true);
        this.reconcileIfLocalVersionSpec(to, true);
        WorkspaceLock lock = this.lockIfLocal(w);
        try {
            GetOperation[] toReturn = super.rollback(workspaceName, workspaceOwner, items, itemVersion, from, to, rollbackOptions, lockLevel, conflicts, failures, itemAttributeFilters, itemPropertyFilters, changePendedFlags);
            this.syncWorkingFoldersIfNecessary(w, changePendedFlags.get());
            this.syncPendingChangesIfLocal(w, toReturn, itemPropertyFilters);
            GetOperation[] getOperationArray = toReturn;
            return getOperationArray;
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    @Override
    public Failure[] setPendingChangeProperty(String workspaceName, String workspaceOwner, ArtifactPropertyValue[] pendingChangePropertyValues) {
        this.reconcileIfLocal(workspaceName, workspaceOwner);
        return super.setPendingChangeProperty(workspaceName, workspaceOwner, pendingChangePropertyValues);
    }

    @Override
    public void setVersionedItemProperty(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs, VersionSpec versionSpec, DeletedState deletedState, ItemType itemType, PropertyValue[] propertyValues) {
        this.reconcileIfAnyLocalItemSpecs(workspaceName, workspaceOwner, itemSpecs, true);
        this.reconcileIfLocalVersionSpec(versionSpec, true);
        super.setVersionedItemProperty(workspaceName, workspaceOwner, itemSpecs, versionSpec, deletedState, itemType, propertyValues);
    }

    @Override
    public Failure[] shelve(String workspaceName, String workspaceOwner, String[] serverItems, Shelveset shelveset, boolean replace) {
        this.reconcileIfLocal(workspaceName, workspaceOwner);
        return super.shelve(workspaceName, workspaceOwner, serverItems, shelveset, replace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperation[] undoPendingChanges(String workspaceName, String ownerName, final ItemSpec[] items, AtomicReference<Failure[]> failures, String[] itemAttributeFilters, final String[] itemPropertyFilters, AtomicBoolean onlineOperation, final boolean deleteAdds, AtomicReference<ChangePendedFlags> changePendedFlags) {
        onlineOperation.set(true);
        changePendedFlags.set(ChangePendedFlags.NONE);
        final Workspace localWorkspace = this.getLocalWorkspace(workspaceName, ownerName);
        if (localWorkspace != null) {
            final AtomicReference<GetOperation[]> toReturn = new AtomicReference<GetOperation[]>();
            final LocalWorkspaceTransaction transaction = new LocalWorkspaceTransaction(localWorkspace);
            try {
                final AtomicReference<Failure[]> delegateFailures = new AtomicReference<Failure[]>(new Failure[0]);
                final AtomicBoolean onlineOperationRequired = new AtomicBoolean(false);
                transaction.execute(new AllTablesTransaction(){

                    @Override
                    public void invoke(LocalWorkspaceProperties wp, WorkspaceVersionTable lv, LocalPendingChangesTable pc) {
                        toReturn.set(LocalDataAccessLayer.undoPendingChanges(localWorkspace, wp, lv, pc, items, delegateFailures, onlineOperationRequired, itemPropertyFilters));
                        if (onlineOperationRequired.get()) {
                            transaction.abort();
                            toReturn.set(null);
                        }
                        if (toReturn.get() != null) {
                            HashMap<String, GetOperation> localItemDictionary = null;
                            for (GetOperation op : (GetOperation[])toReturn.get()) {
                                GetOperation existingItem;
                                WorkspaceLocalItem item;
                                if (op.getItemType() != ItemType.FILE || op.getTargetLocalItem() == null || op.getTargetLocalItem().length() <= 0 || LocalPath.equals(op.getTargetLocalItem(), op.getCurrentLocalItem()) || (item = lv.getByLocalItem(op.getTargetLocalItem())) != null && !item.isDeleted() || !new File(op.getTargetLocalItem()).exists()) continue;
                                if (localItemDictionary == null) {
                                    localItemDictionary = new HashMap<String, GetOperation>();
                                    for (GetOperation getOp : (GetOperation[])toReturn.get()) {
                                        if (getOp.getTargetLocalItem() == null || getOp.getTargetLocalItem().length() <= 0 || getOp.getItemType() != ItemType.FILE) continue;
                                        GetOperation currentValue = (GetOperation)localItemDictionary.get(getOp.getTargetLocalItem());
                                        if (currentValue != null) {
                                            if (!currentValue.getChangeType().contains(ChangeType.ADD)) continue;
                                            localItemDictionary.put(getOp.getTargetLocalItem(), getOp);
                                            continue;
                                        }
                                        localItemDictionary.put(getOp.getTargetLocalItem(), getOp);
                                    }
                                }
                                if ((existingItem = (GetOperation)localItemDictionary.get(op.getTargetLocalItem())) != null && existingItem.getChangeType().contains(ChangeType.ADD) && deleteAdds || existingItem != null && WebServiceLayerLocalWorkspaces.this.tryMoveAddLocation(existingItem, localItemDictionary)) continue;
                                throw new VersionControlException(MessageFormat.format(Messages.getString("WebServiceLayerLocalWorkspaces.UndoItemExistsLocallyFormat"), op.getCurrentLocalItem() != null && op.getCurrentLocalItem().length() > 0 ? op.getCurrentLocalItem() : op.getTargetLocalItem(), op.getTargetLocalItem()));
                            }
                        }
                    }
                });
                if (null != toReturn.get()) {
                    onlineOperation.set(false);
                    failures.set(delegateFailures.get());
                    GetOperation[] getOperationArray = (GetOperation[])toReturn.get();
                    return getOperationArray;
                }
            }
            finally {
                try {
                    transaction.close();
                }
                catch (IOException e) {
                    throw new VersionControlException(e);
                }
            }
            Workspace w = this.reconcileIfLocal(workspaceName, ownerName);
            WorkspaceLock lock = this.lockIfLocal(w);
            try {
                try {
                    ElementDeserializable response;
                    if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                        response = this.getRepository5().undoPendingChangesInLocalWorkspace(workspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemPropertyFilters, itemAttributeFilters, 399);
                        failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository5Soap_UndoPendingChangesInLocalWorkspaceResponse)response).getFailures()));
                        changePendedFlags.set(new ChangePendedFlags(((_Repository5Soap_UndoPendingChangesInLocalWorkspaceResponse)response).getChangePendedFlags()));
                        toReturn.set((GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_Repository5Soap_UndoPendingChangesInLocalWorkspaceResponse)response).getUndoPendingChangesInLocalWorkspaceResult()));
                    } else {
                        response = this.getRepository4().undoPendingChangesInLocalWorkspace(workspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemPropertyFilters, itemAttributeFilters);
                        failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository4Soap_UndoPendingChangesInLocalWorkspaceResponse)response).getFailures()));
                        changePendedFlags.set(new ChangePendedFlags(((_Repository4Soap_UndoPendingChangesInLocalWorkspaceResponse)response).getChangePendedFlags()));
                        toReturn.set((GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_Repository4Soap_UndoPendingChangesInLocalWorkspaceResponse)response).getUndoPendingChangesInLocalWorkspaceResult()));
                    }
                }
                catch (ProxyException e) {
                    VersionControlExceptionMapper.map(e);
                }
                this.syncWorkingFoldersIfNecessary(w, changePendedFlags.get());
                this.syncPendingChangesIfLocal(w, (GetOperation[])toReturn.get(), itemPropertyFilters);
                if (null != toReturn.get()) {
                    for (GetOperation op : (GetOperation[])toReturn.get()) {
                        if (!op.getChangeType().contains(ChangeType.ADD)) continue;
                        localWorkspace.getWorkspaceWatcher().markPathChanged("");
                        break;
                    }
                }
                GetOperation[] getOperationArray = (GetOperation[])toReturn.get();
                return getOperationArray;
            }
            finally {
                if (lock != null) {
                    lock.close();
                }
            }
        }
        return super.undoPendingChanges(workspaceName, ownerName, items, failures, itemAttributeFilters, itemPropertyFilters, onlineOperation, deleteAdds, changePendedFlags);
    }

    private boolean tryMoveAddLocation(GetOperation conflictingAdd, Map<String, GetOperation> localItemDictionary) {
        if (!conflictingAdd.getChangeType().contains(ChangeType.ADD)) {
            return false;
        }
        int iteration = 0;
        String extension = ".add";
        do {
            String newLocalItem;
            if (!localItemDictionary.containsKey(newLocalItem = conflictingAdd.getTargetLocalItem() + extension) && !new File(newLocalItem).exists()) {
                conflictingAdd.setTargetLocalItem(newLocalItem);
                return true;
            }
            extension = ".add" + ++iteration;
        } while (iteration <= 10);
        return false;
    }

    @Override
    public LabelResult[] unlabelItem(String workspaceName, String workspaceOwner, String labelName, String labelScope, ItemSpec[] items, VersionSpec version, AtomicReference<Failure[]> failures) {
        this.reconcileIfAnyLocalItemSpecs(workspaceName, workspaceOwner, items, true);
        this.reconcileIfLocalVersionSpec(version, true);
        return super.unlabelItem(workspaceName, workspaceOwner, labelName, labelScope, items, version, failures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shelveset unshelve(String shelvesetName, String shelvesetOwner, String workspaceName, String workspaceOwner, ItemSpec[] items, String[] itemAttributeFilters, String[] itemPropertyFilters, String[] shelvesetPropertyFilters, boolean merge, AtomicReference<Failure[]> failures, AtomicReference<GetOperation[]> getOperations, AtomicReference<Conflict[]> conflicts, AtomicReference<ChangePendedFlags> changePendedFlags) {
        Workspace w = this.reconcileIfLocal(workspaceName, workspaceOwner);
        WorkspaceLock lock = this.lockIfLocal(w);
        try {
            Shelveset toReturn = super.unshelve(shelvesetName, shelvesetOwner, workspaceName, workspaceOwner, items, itemAttributeFilters, itemPropertyFilters, shelvesetPropertyFilters, merge, failures, getOperations, conflicts, changePendedFlags);
            this.syncWorkingFoldersIfNecessary(w, changePendedFlags.get());
            this.syncPendingChangesIfLocal(w, getOperations.get(), itemPropertyFilters);
            Shelveset shelveset = toReturn;
            return shelveset;
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workspace updateWorkspace(String oldWorkspaceName, String ownerName, Workspace newWorkspace, SupportedFeatures supportedFeatures) {
        Workspace localWorkspace = this.reconcileIfLocal(oldWorkspaceName, ownerName);
        WorkspaceLock lock = this.lockIfLocal(localWorkspace);
        try {
            Workspace returnedWorkspace = super.updateWorkspace(oldWorkspaceName, ownerName, newWorkspace, supportedFeatures);
            if (null != localWorkspace) {
                LocalDataAccessLayer.setWorkingFolders(localWorkspace, returnedWorkspace.getFolders());
            }
            Workspace workspace = returnedWorkspace;
            return workspace;
        }
        finally {
            if (lock != null) {
                lock.close();
            }
        }
    }

    @Override
    public Workspace updateWorkspaceNoReconcile(String oldWorkspaceName, String ownerName, Workspace newWorkspace, SupportedFeatures supportedFeatures) {
        return super.updateWorkspace(oldWorkspaceName, ownerName, newWorkspace, supportedFeatures);
    }
}

