/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.exceptions.WorkspaceVersionTableException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BinaryReader;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.WorkspaceVersionTable;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import com.microsoft.tfs.util.NotYetImplementedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class WorkspaceVersionTableHeader
extends LocalMetadataTable {
    private static final short MAGIC_1 = 4660;
    private static final short MAGIC_2 = -22580;
    private static final int SCHEMA_VERSION_1 = 1;
    private static final int SCHEMA_VERSION_2 = 2;
    private boolean pendingReconcile;

    public WorkspaceVersionTableHeader(String fileName, LocalMetadataTable cachedLoadSource) throws Exception {
        super(fileName, cachedLoadSource);
    }

    @Override
    protected void initialize() {
        this.pendingReconcile = false;
    }

    @Override
    protected boolean cachedLoad(LocalMetadataTable source) {
        WorkspaceVersionTable lvCached = null;
        if (source instanceof WorkspaceVersionTable) {
            lvCached = (WorkspaceVersionTable)source;
        }
        if (null != lvCached) {
            this.pendingReconcile = lvCached.getPendingReconcile();
            return true;
        }
        WorkspaceVersionTableHeader lvhCached = null;
        if (source instanceof WorkspaceVersionTableHeader) {
            lvhCached = (WorkspaceVersionTableHeader)source;
        }
        if (null != lvhCached) {
            this.pendingReconcile = lvhCached.pendingReconcile;
            return true;
        }
        return false;
    }

    public boolean getPendingReconcile() {
        return this.pendingReconcile;
    }

    @Override
    protected void load(InputStream is) throws IOException {
        block8: {
            BinaryReader br = new BinaryReader(is, "UTF-16LE");
            try {
                short magic = br.readInt16();
                if (4660 != magic && -22580 != magic) {
                    throw new WorkspaceVersionTableException("The workspace version table contains an unknown schema version.");
                }
                int schemaVersion = br.readInt32();
                if (schemaVersion == 1 || schemaVersion == 2) {
                    this.loadFromVersion1(br);
                    break block8;
                }
                throw new WorkspaceVersionTableException("The workspace version table contains an unknown schema version.");
            }
            catch (Exception e) {
                if (e instanceof WorkspaceVersionTableException) {
                    throw (WorkspaceVersionTableException)e;
                }
                throw new WorkspaceVersionTableException(e);
            }
            finally {
                br.close();
            }
        }
    }

    private void loadFromVersion1(BinaryReader br) throws IOException {
        this.pendingReconcile = br.readBoolean();
    }

    @Override
    protected boolean save(OutputStream os) {
        throw new NotYetImplementedException();
    }
}

