/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata.mapper;

import com.microsoft.tfs.core.clients.workitem.internal.metadata.mapper.SQLMapper;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.mapper.SQLStringMappings;

public class MSSQLMapper
implements SQLMapper {
    @Override
    public String getSQLColumnTypeFromMetadataColumnType(String type, String tableName, String columnName) {
        if ("System.Guid".equals(type)) {
            return "varchar(80)";
        }
        if ("System.Int32".equals(type)) {
            return "int";
        }
        if ("System.String".equals(type)) {
            int len = SQLStringMappings.getStringColumnLength(tableName, columnName);
            if (len == -1) {
                return "text";
            }
            return "varchar(" + len + ")";
        }
        if ("System.Boolean".equals(type)) {
            return "bit";
        }
        if ("System.DateTime".equals(type)) {
            return "datetime";
        }
        if ("System.UInt64".equals(type)) {
            return "bigint";
        }
        return "text";
    }

    @Override
    public Object getSQLObject(String type, String value) {
        if ("System.Int32".equals(type)) {
            return Integer.valueOf(value);
        }
        if ("System.Boolean".equals(type)) {
            return "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("System.UInt64".equals(type)) {
            return Long.valueOf(value);
        }
        return value;
    }
}

