/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.externaltools;

import com.microsoft.tfs.core.externaltools.ExternalTool;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public final class ExternalToolAssociation {
    private final Set<String> extensions = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private ExternalTool tool;
    private static final String EXTENSION_MEMENTO_NAME = "extension";
    private static final String TOOL_MEMENTO_NAME = "tool";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalToolAssociation(String[] extensions, ExternalTool tool) {
        ExternalToolAssociation externalToolAssociation = this;
        synchronized (externalToolAssociation) {
            if (extensions != null) {
                this.putExtensions(extensions);
            }
            this.tool = tool;
        }
    }

    public synchronized boolean putExtension(String extension) {
        Check.notNull(extension, EXTENSION_MEMENTO_NAME);
        extension = extension.trim();
        Check.notEmpty(extension, EXTENSION_MEMENTO_NAME);
        return this.extensions.add(extension);
    }

    public synchronized boolean putExtensions(String[] extensions) {
        if (extensions == null) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < extensions.length; ++i) {
            if (!this.putExtension(extensions[i])) continue;
            changed = true;
        }
        return changed;
    }

    public synchronized String[] getExtensions() {
        return this.extensions.toArray(new String[this.extensions.size()]);
    }

    public synchronized void clearExtensions() {
        this.extensions.clear();
    }

    public synchronized void setTool(ExternalTool tool) {
        this.tool = tool;
    }

    public synchronized ExternalTool getTool() {
        return this.tool;
    }

    public synchronized boolean containsExtension(String fileExtension) {
        Check.notNull(fileExtension, "fileExtension");
        return this.extensions.contains(fileExtension);
    }

    public synchronized void saveToMemento(Memento memento) {
        Check.notNull(memento, "memento");
        for (String extension : this.extensions) {
            Memento extensionMemento = memento.createChild(EXTENSION_MEMENTO_NAME);
            extensionMemento.putTextData(extension);
        }
        if (this.tool != null) {
            Memento toolMemento = memento.createChild(TOOL_MEMENTO_NAME);
            this.tool.saveToMemento(toolMemento);
        }
    }

    public static ExternalToolAssociation loadFromMemento(Memento memento) {
        Check.notNull(memento, "memento");
        ArrayList<String> extensions = new ArrayList<String>();
        Memento[] extensionsChildren = memento.getChildren(EXTENSION_MEMENTO_NAME);
        for (int i = 0; i < extensionsChildren.length; ++i) {
            extensions.add(extensionsChildren[i].getTextData());
        }
        ExternalTool tool = null;
        if (memento.getChild(TOOL_MEMENTO_NAME) != null) {
            tool = ExternalTool.loadFromMemento(memento.getChild(TOOL_MEMENTO_NAME));
        }
        return new ExternalToolAssociation(extensions.toArray(new String[extensions.size()]), tool);
    }
}

