/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.util;

import com.microsoft.tfs.core.httpclient.HttpConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdleConnectionHandler {
    private static final Log log = LogFactory.getLog(IdleConnectionHandler.class);
    private final Map connectionToAdded = new HashMap();

    public void add(HttpConnection connection) {
        Long timeAdded = new Long(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding connection " + connection.getID() + " at: " + timeAdded));
        }
        this.connectionToAdded.put(connection, timeAdded);
    }

    public void remove(HttpConnection connection) {
        log.debug((Object)("Removing connection " + connection.getID()));
        this.connectionToAdded.remove(connection);
    }

    public void removeAll() {
        log.debug((Object)("Idle connections count = " + this.connectionToAdded.size()));
        this.connectionToAdded.clear();
    }

    public void closeIdleConnections(long idleTime) {
        long idleTimeout = System.currentTimeMillis() - idleTime;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking for connections, idleTimeout: " + idleTimeout));
        }
        Iterator connectionIter = this.connectionToAdded.keySet().iterator();
        while (connectionIter.hasNext()) {
            HttpConnection conn = (HttpConnection)connectionIter.next();
            Long connectionTime = (Long)this.connectionToAdded.get(conn);
            if (connectionTime > idleTimeout) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing connection " + conn.getID() + ", connection time: " + connectionTime));
            }
            connectionIter.remove();
            conn.close();
        }
    }
}

