/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.core.persistence.LockMode;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.core.util.internal.MementoRepositorySerializer;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MementoRepository {
    private static final Log log = LogFactory.getLog(MementoRepository.class);
    private static final String CHILD_STORE_NAME = "TEE-Mementos";
    private static final String MEMENTO_VALUE_FILE_EXTENSION = ".xml";
    private final PersistenceStore store;

    public MementoRepository(PersistenceStore store) {
        Check.notNull(store, "store");
        this.store = store.getChildStore(CHILD_STORE_NAME);
    }

    public Memento load(String key) {
        Check.notNullOrEmpty(key, "key");
        try {
            return (Memento)this.store.retrieveItem(key + MEMENTO_VALUE_FILE_EXTENSION, LockMode.WAIT_FOREVER, null, new MementoRepositorySerializer());
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("unable to load settings for key '{0}'", key), (Throwable)e);
            return null;
        }
    }

    public boolean save(String key, Memento memento) {
        Check.notNullOrEmpty(key, "key");
        Check.notNull(memento, "memento");
        try {
            this.store.storeItem(key + MEMENTO_VALUE_FILE_EXTENSION, memento, LockMode.WAIT_FOREVER, null, new MementoRepositorySerializer());
        }
        catch (Exception e) {
            log.error((Object)MessageFormat.format("unable to save settings for key '{0}'", key), (Throwable)e);
            return false;
        }
        return true;
    }
}

