/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.exceptions;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.ws.runtime.exceptions.TransportAuthException;
import com.microsoft.tfs.util.Check;

public class FederatedAuthException
extends TransportAuthException {
    private final String serverURI;
    private final String authenticationURL;
    private final String fedAuthIssuer;
    private final String fedAuthRealm;
    private final String[] mechanisms;
    private final Credentials credentials;
    private final String serverErorMessage;

    public FederatedAuthException(String serverURI, String authenticationURL, String fedAuthIssuer, String fedAuthRealm, String[] mechanisms, Credentials credentials, String serverErorMessage) {
        super(serverURI);
        Check.notNull(serverURI, "serverURI");
        Check.notNull(authenticationURL, "authenticationURL");
        Check.notNull(fedAuthIssuer, "fedAuthIssuer");
        Check.notNull(fedAuthRealm, "fedAuthRealm");
        Check.notNull(mechanisms, "mechanisms");
        this.serverURI = serverURI;
        this.authenticationURL = authenticationURL;
        this.fedAuthIssuer = fedAuthIssuer;
        this.fedAuthRealm = fedAuthRealm;
        this.mechanisms = mechanisms;
        this.credentials = credentials;
        this.serverErorMessage = serverErorMessage;
    }

    public String getServerURI() {
        return this.serverURI;
    }

    public String getAuthenticationURL() {
        return this.authenticationURL;
    }

    public String getFedAuthIssuer() {
        return this.fedAuthIssuer;
    }

    public String getFedAuthRealm() {
        return this.fedAuthRealm;
    }

    public String[] getMechanisms() {
        return this.mechanisms;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public String getMessage() {
        return this.serverErorMessage;
    }
}

