/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.jni.FileSystem;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.Messages;
import com.microsoft.tfs.jni.internal.filesystem.NativeFileSystem;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class FileSystemUtils
implements FileSystem {
    private static final FileSystemUtils instance = new FileSystemUtils();
    private final NativeFileSystem nativeImpl = new NativeFileSystem();

    public static FileSystemUtils getInstance() {
        return instance;
    }

    private FileSystemUtils() {
    }

    @Override
    public FileSystemAttributes getAttributes(String filepath) {
        try {
            FileSystemAttributes attrs = this.nativeImpl.getAttributes(filepath);
            if (attrs.isSymbolicLink()) {
                attrs.setArchive(false);
                attrs.setExecutable(false);
                attrs.setHidden(false);
                attrs.setNotContentIndexed(false);
                attrs.setOwnerOnly(false);
                attrs.setPublicWritable(false);
                attrs.setReadOnly(true);
                attrs.setSystem(false);
            }
            return attrs;
        }
        catch (RuntimeException e) {
            String format = Messages.getString("FileSystemUtils.MessagePlusPathFormat");
            throw new RuntimeException(MessageFormat.format(format, e.getLocalizedMessage(), filepath));
        }
    }

    public FileSystemAttributes getAttributes(File file) {
        Check.notNull(file, "file");
        return this.getAttributes(file.getPath());
    }

    @Override
    public boolean setAttributes(String filepath, FileSystemAttributes attributes) {
        FileSystemAttributes attrs = this.getAttributes(filepath);
        if (attrs.isSymbolicLink()) {
            return true;
        }
        return this.nativeImpl.setAttributes(filepath, attributes);
    }

    public boolean setAttributes(File file, FileSystemAttributes attributes) {
        Check.notNull(file, "file");
        return this.setAttributes(file.getPath(), attributes);
    }

    @Override
    public String getOwner(String path) {
        Check.notNull(path, "path");
        return this.nativeImpl.getOwner(path);
    }

    @Override
    public void setOwner(String path, String owner) {
        Check.notNull(path, "path");
        Check.notNull(owner, "owner");
        this.nativeImpl.setOwner(path, owner);
    }

    @Override
    public void grantInheritableFullControl(String path, String user, String copyExplicitRulesFromPath) {
        Check.notNull(path, "path");
        Check.notNull(user, "user");
        this.nativeImpl.grantInheritableFullControl(path, user, copyExplicitRulesFromPath);
    }

    @Override
    public void copyExplicitDACLEntries(String sourcePath, String targetPath) {
        Check.notNull(sourcePath, "sourcePath");
        Check.notNull(targetPath, "targetPath");
        this.nativeImpl.copyExplicitDACLEntries(sourcePath, targetPath);
    }

    @Override
    public void removeExplicitAllowEntries(String path, String user) {
        Check.notNull(path, "path");
        Check.notNull(user, "user");
        this.nativeImpl.removeExplicitAllowEntries(path, user);
    }

    @Override
    public boolean createSymbolicLink(String oldpath, String newpath) {
        return this.nativeImpl.createSymbolicLink(oldpath, newpath);
    }

    public String getSymbolicLink(String path) {
        return this.nativeImpl.getSymbolicLink(path);
    }

    public File createTempFileSecure(String prefix, String suffix, File parentFile) throws IOException {
        return this.nativeImpl.createTempFileSecure(prefix, suffix, parentFile);
    }

    @Override
    public String[] listMacExtendedAttributes(String filepath) {
        return this.nativeImpl.listMacExtendedAttributes(filepath);
    }

    @Override
    public int readMacExtendedAttribute(String filepath, String attribute2, byte[] buffer, int size, long position) {
        return this.nativeImpl.readMacExtendedAttribute(filepath, attribute2, buffer, size, position);
    }

    @Override
    public boolean writeMacExtendedAttribute(String filepath, String attribute2, byte[] buffer, int size, long position) {
        return this.nativeImpl.writeMacExtendedAttribute(filepath, attribute2, buffer, size, position);
    }

    @Override
    public byte[] getMacExtendedAttribute(String filepath, String attribute2) {
        return this.nativeImpl.getMacExtendedAttribute(filepath, attribute2);
    }

    @Override
    public boolean setMacExtendedAttribute(String filepath, String attribute2, byte[] value) {
        return this.nativeImpl.setMacExtendedAttribute(filepath, attribute2, value);
    }
}

