/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.fileformat.entry;

import com.microsoft.tfs.util.ByteArrayUtils;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.Date;

public class AppleForkedDateEntry {
    public static final int DATE_ENTRY_SIZE = 16;
    private Date creationDate;
    private Date modificationDate;
    private Date backupDate;
    private Date accessDate;

    public AppleForkedDateEntry() {
    }

    public AppleForkedDateEntry(Date creationDate, Date modificationDate, Date backupDate, Date accessDate) {
        this.setCreationDate(creationDate);
        this.setModificationDate(modificationDate);
        this.setBackupDate(backupDate);
        this.setAccessDate(accessDate);
    }

    public AppleForkedDateEntry(byte[] dateEntry) {
        this.decode(dateEntry);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public Date getBackupDate() {
        return this.backupDate;
    }

    public void setBackupDate(Date backupDate) {
        this.backupDate = backupDate;
    }

    public Date getAccessDate() {
        return this.accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this.accessDate = accessDate;
    }

    public void decode(byte[] dateEntry) {
        Check.notNull(dateEntry, "dateEntry");
        Check.isTrue(dateEntry.length == 16, "dateEntry.length == DATE_ENTRY_SIZE");
        long javaCreationTime = this.getJavaTime(ByteArrayUtils.getUnsignedInt32(dateEntry, 0));
        long javaModificationTime = this.getJavaTime(ByteArrayUtils.getUnsignedInt32(dateEntry, 4));
        long javaBackupTime = this.getJavaTime(ByteArrayUtils.getUnsignedInt32(dateEntry, 8));
        long javaAccessTime = this.getJavaTime(ByteArrayUtils.getUnsignedInt32(dateEntry, 12));
        this.creationDate = new Date(javaCreationTime);
        this.modificationDate = new Date(javaModificationTime);
        this.backupDate = new Date(javaBackupTime);
        this.accessDate = new Date(javaAccessTime);
    }

    public byte[] encode() {
        byte[] dateEntry = new byte[16];
        int appleCreationTime = this.creationDate != null ? this.getAppleTime(this.creationDate.getTime()) : 0;
        int appleModificationTime = this.modificationDate != null ? this.getAppleTime(this.modificationDate.getTime()) : 0;
        int appleBackupTime = this.backupDate != null ? this.getAppleTime(this.backupDate.getTime()) : 0;
        int appleAccessTime = this.accessDate != null ? this.getAppleTime(this.accessDate.getTime()) : 0;
        ByteArrayUtils.putInt32(dateEntry, 0, appleCreationTime);
        ByteArrayUtils.putInt32(dateEntry, 4, appleModificationTime);
        ByteArrayUtils.putInt32(dateEntry, 8, appleBackupTime);
        ByteArrayUtils.putInt32(dateEntry, 12, appleAccessTime);
        return dateEntry;
    }

    private final int getAppleTime(long javaTime) {
        long unixTime = javaTime / 1000L;
        return (int)(unixTime - 946684800L);
    }

    private final long getJavaTime(long appleTime) {
        long unixTime = appleTime + 946684800L;
        return unixTime * 1000L;
    }

    public String toString() {
        return MessageFormat.format("creation={0}, modification={1}, backup={2}, access={3}", this.creationDate, this.modificationDate, this.backupDate, this.accessDate);
    }
}

