/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream;

import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedConstants;
import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedEntryDescriptor;
import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedHeader;
import com.microsoft.tfs.jni.appleforked.stream.decoder.AppleForkedEntryDescriptorArrayDecoder;
import com.microsoft.tfs.jni.appleforked.stream.decoder.AppleForkedHeaderDecoder;
import com.microsoft.tfs.jni.appleforked.stream.decoder.entry.AppleForkedEntryDecoder;
import com.microsoft.tfs.jni.appleforked.stream.decoder.entry.AppleForkedEntryDecoderFactory;
import com.microsoft.tfs.jni.appleforked.stream.decoder.entry.AppleForkedNullEntryDecoder;
import com.microsoft.tfs.util.chunkingcodec.ChunkedDecoder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public abstract class AppleForkedDecoderStream
extends OutputStream {
    private final int magic;
    private final List ignoredList = new ArrayList();
    private long index = 0L;
    private final AppleForkedHeaderDecoder headerDecoder = new AppleForkedHeaderDecoder();
    private AppleForkedHeader header;
    private AppleForkedEntryDescriptorArrayDecoder entryDescriptorDecoder;
    private AppleForkedEntryDescriptor[] entryDescriptor;
    private AppleForkedEntryDecoder[] entryDecoder;
    private final File outputFile;

    public AppleForkedDecoderStream(File file, int magic) {
        this.magic = magic;
        this.outputFile = file;
    }

    public AppleForkedDecoderStream(String string, int magic) {
        this(new File(string), magic);
    }

    protected boolean isIgnored(long entryType) {
        return this.ignoredList.contains(new Long(entryType));
    }

    public final void ignoreEntry(long entryType) {
        this.ignoredList.add(new Long(entryType));
    }

    @Override
    public final void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public final void write(byte[] buf, int off, int len) throws IOException {
        int writelen = 0;
        while (writelen < len) {
            int passlen;
            if (!this.headerDecoder.isComplete()) {
                passlen = this.headerDecoder.decode(buf, off + writelen, len - writelen);
                if (this.headerDecoder.isComplete()) {
                    this.setupHeader();
                }
            } else if (!this.entryDescriptorDecoder.isComplete()) {
                passlen = this.entryDescriptorDecoder.decode(buf, off + writelen, len - writelen);
                if (this.entryDescriptorDecoder.isComplete()) {
                    this.setupEntries();
                }
            } else {
                AppleForkedEntryDescriptor currentDescriptor = null;
                ChunkedDecoder currentDecoder = null;
                long nextOffset = -1L;
                for (int i = 0; i < this.entryDescriptor.length; ++i) {
                    if (this.index >= this.entryDescriptor[i].getOffset() && this.index < this.entryDescriptor[i].getOffset() + this.entryDescriptor[i].getLength()) {
                        currentDescriptor = this.entryDescriptor[i];
                        currentDecoder = this.entryDecoder[i];
                        break;
                    }
                    if (this.index >= this.entryDescriptor[i].getOffset() || this.entryDescriptor[i].getOffset() >= nextOffset) continue;
                    nextOffset = this.entryDescriptor[i].getOffset();
                }
                if (currentDescriptor != null) {
                    if (currentDecoder.isComplete()) {
                        throw new IOException(MessageFormat.format("Entry {0} is full", Long.toString(currentDescriptor.getType())));
                    }
                    passlen = currentDecoder.decode(buf, off + writelen, len - writelen);
                } else {
                    passlen = nextOffset < 0L ? len - writelen : (int)Math.min(nextOffset - this.index, (long)(len - writelen));
                }
            }
            writelen += passlen;
            this.index += (long)passlen;
        }
    }

    private final void setupHeader() throws IOException {
        this.header = this.headerDecoder.getHeader();
        if (this.header.getMagic() != this.magic) {
            throw new IOException(MessageFormat.format("File is not an {0} file", AppleForkedConstants.getNameFromMagic(this.magic)));
        }
        if (this.header.getVersion() != 65536 && this.header.getVersion() != 131072) {
            throw new IOException(MessageFormat.format("File is unknown AppleSingle version: 0x{0}", Integer.toHexString(this.header.getVersion())));
        }
        this.entryDescriptorDecoder = new AppleForkedEntryDescriptorArrayDecoder(this.header.getEntryCount());
    }

    private final void setupEntries() throws IOException {
        this.entryDescriptor = this.entryDescriptorDecoder.getEntryDescriptors();
        this.entryDecoder = new AppleForkedEntryDecoder[this.entryDescriptor.length];
        for (int i = 0; i < this.entryDescriptor.length; ++i) {
            this.entryDecoder[i] = this.isIgnored(this.entryDescriptor[i].getType()) ? new AppleForkedNullEntryDecoder(this.entryDescriptor[i]) : AppleForkedEntryDecoderFactory.getDecoder(this.entryDescriptor[i], this.outputFile);
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.entryDecoder != null) {
            boolean complete = true;
            for (int i = 0; i < this.entryDecoder.length; ++i) {
                if (this.entryDecoder[i] == null) {
                    complete = false;
                    continue;
                }
                if (!this.entryDecoder[i].isComplete()) {
                    complete = false;
                }
                this.entryDecoder[i].close();
            }
            if (!complete) {
                throw new IOException(MessageFormat.format("Incomplete {0} file", AppleForkedConstants.getNameFromMagic(this.magic)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

